// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical transcription job.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalTranscriptionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMedicalTranscriptionJobInput"}

	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the medical transcription job.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s GetMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMedicalTranscriptionJob = "GetMedicalTranscriptionJob"

// GetMedicalTranscriptionJobRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Returns information about a transcription job from Amazon Transcribe Medical.
// To see the status of the job, check the TranscriptionJobStatus field. If
// the status is COMPLETED, the job is finished. You find the results of the
// completed job in the TranscriptFileUri field.
//
//    // Example sending a request using GetMedicalTranscriptionJobRequest.
//    req := client.GetMedicalTranscriptionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *Client) GetMedicalTranscriptionJobRequest(input *GetMedicalTranscriptionJobInput) GetMedicalTranscriptionJobRequest {
	op := &aws.Operation{
		Name:       opGetMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalTranscriptionJobInput{}
	}

	req := c.newRequest(op, input, &GetMedicalTranscriptionJobOutput{})

	return GetMedicalTranscriptionJobRequest{Request: req, Input: input, Copy: c.GetMedicalTranscriptionJobRequest}
}

// GetMedicalTranscriptionJobRequest is the request type for the
// GetMedicalTranscriptionJob API operation.
type GetMedicalTranscriptionJobRequest struct {
	*aws.Request
	Input *GetMedicalTranscriptionJobInput
	Copy  func(*GetMedicalTranscriptionJobInput) GetMedicalTranscriptionJobRequest
}

// Send marshals and sends the GetMedicalTranscriptionJob API request.
func (r GetMedicalTranscriptionJobRequest) Send(ctx context.Context) (*GetMedicalTranscriptionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMedicalTranscriptionJobResponse{
		GetMedicalTranscriptionJobOutput: r.Request.Data.(*GetMedicalTranscriptionJobOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMedicalTranscriptionJobResponse is the response type for the
// GetMedicalTranscriptionJob API operation.
type GetMedicalTranscriptionJobResponse struct {
	*GetMedicalTranscriptionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMedicalTranscriptionJob request.
func (r *GetMedicalTranscriptionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
