// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language spoken in the input media file. US English
	// (en-US) is the valid value for medical transcription jobs. Any other value
	// you enter for language code results in a BadRequestException error.
	//
	// LanguageCode is a required field
	LanguageCode LanguageCode `type:"string" required:"true" enum:"true"`

	// Describes the input media file in a transcription request.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The audio format of the input media file.
	MediaFormat MediaFormat `type:"string" enum:"true"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	//
	// If you do not specify the media sample rate, Amazon Transcribe Medical determines
	// the sample rate. If you specify the sample rate, it must match the rate detected
	// by Amazon Transcribe Medical. In most cases, you should leave the MediaSampleRateHertz
	// field blank and let Amazon Transcribe Medical determine the sample rate.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// The name of the medical transcription job. You can't use the strings "."
	// or ".." by themselves as the job name. The name must also be unique within
	// an AWS account. If you try to create a medical transcription job with the
	// same name as a previous medical transcription job you will receive a ConflictException
	// error.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 location where the transcription is stored.
	//
	// You must set OutputBucketName for Amazon Transcribe Medical to store the
	// transcription results. Your transcript appears in the S3 location you specify.
	// When you call the GetMedicalTranscriptionJob, the operation returns this
	// location in the TranscriptFileUri field. The S3 bucket must have permissions
	// that allow Amazon Transcribe Medical to put files in the bucket. For more
	// information, see Permissions Required for IAM User Roles (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// You can specify an AWS Key Management Service (KMS) key to encrypt the output
	// of your transcription using the OutputEncryptionKMSKeyId parameter. If you
	// don't specify a KMS key, Amazon Transcribe Medical uses the default Amazon
	// S3 key for server-side encryption of transcripts that are placed in your
	// S3 bucket.
	//
	// OutputBucketName is a required field
	OutputBucketName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key
	// used to encrypt the output of the transcription job. The user calling the
	// StartMedicalTranscriptionJob operation must have permission to use the specified
	// KMS key.
	//
	// You use either of the following to identify a KMS key in the current account:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key in the current
	// account or another account:
	//
	//    * Amazon Resource Name (ARN) of a KMS key in the current account or another
	//    account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
	//
	// If you don't specify an encryption key, the output of the medical transcription
	// job is encrypted with the default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location in the OutputBucketName parameter.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// Optional settings for the medical transcription job.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// The medical specialty of any clinician speaking in the input media.
	//
	// Specialty is a required field
	Specialty Specialty `type:"string" required:"true" enum:"true"`

	// The type of speech in the input audio. CONVERSATION refers to conversations
	// between two or more speakers, e.g., a conversations between doctors and patients.
	// DICTATION refers to single-speaker dictated speech, e.g., for clinical notes.
	//
	// Type is a required field
	Type Type `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StartMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMedicalTranscriptionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartMedicalTranscriptionJobInput"}
	if len(s.LanguageCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if s.Media == nil {
		invalidParams.Add(aws.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(aws.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}

	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if s.OutputBucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputBucketName"))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if len(s.Specialty) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Specialty"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(aws.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// A batch job submitted to transcribe medical speech to text.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s StartMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartMedicalTranscriptionJob = "StartMedicalTranscriptionJob"

// StartMedicalTranscriptionJobRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Start a batch job to transcribe medical speech to text.
//
//    // Example sending a request using StartMedicalTranscriptionJobRequest.
//    req := client.StartMedicalTranscriptionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *Client) StartMedicalTranscriptionJobRequest(input *StartMedicalTranscriptionJobInput) StartMedicalTranscriptionJobRequest {
	op := &aws.Operation{
		Name:       opStartMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMedicalTranscriptionJobInput{}
	}

	req := c.newRequest(op, input, &StartMedicalTranscriptionJobOutput{})

	return StartMedicalTranscriptionJobRequest{Request: req, Input: input, Copy: c.StartMedicalTranscriptionJobRequest}
}

// StartMedicalTranscriptionJobRequest is the request type for the
// StartMedicalTranscriptionJob API operation.
type StartMedicalTranscriptionJobRequest struct {
	*aws.Request
	Input *StartMedicalTranscriptionJobInput
	Copy  func(*StartMedicalTranscriptionJobInput) StartMedicalTranscriptionJobRequest
}

// Send marshals and sends the StartMedicalTranscriptionJob API request.
func (r StartMedicalTranscriptionJobRequest) Send(ctx context.Context) (*StartMedicalTranscriptionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartMedicalTranscriptionJobResponse{
		StartMedicalTranscriptionJobOutput: r.Request.Data.(*StartMedicalTranscriptionJobOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartMedicalTranscriptionJobResponse is the response type for the
// StartMedicalTranscriptionJob API operation.
type StartMedicalTranscriptionJobResponse struct {
	*StartMedicalTranscriptionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartMedicalTranscriptionJob request.
func (r *StartMedicalTranscriptionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
