// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package transcribeiface provides an interface to enable mocking the Amazon Transcribe Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package transcribeiface

import (
	"github.com/aws/aws-sdk-go-v2/service/transcribe"
)

// ClientAPI provides an interface to enable mocking the
// transcribe.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Transcribe Service.
//    func myFunc(svc transcribeiface.ClientAPI) bool {
//        // Make svc.CreateMedicalVocabulary request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := transcribe.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        transcribeiface.ClientPI
//    }
//    func (m *mockClientClient) CreateMedicalVocabulary(input *transcribe.CreateMedicalVocabularyInput) (*transcribe.CreateMedicalVocabularyOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateMedicalVocabularyRequest(*transcribe.CreateMedicalVocabularyInput) transcribe.CreateMedicalVocabularyRequest

	CreateVocabularyRequest(*transcribe.CreateVocabularyInput) transcribe.CreateVocabularyRequest

	CreateVocabularyFilterRequest(*transcribe.CreateVocabularyFilterInput) transcribe.CreateVocabularyFilterRequest

	DeleteMedicalTranscriptionJobRequest(*transcribe.DeleteMedicalTranscriptionJobInput) transcribe.DeleteMedicalTranscriptionJobRequest

	DeleteMedicalVocabularyRequest(*transcribe.DeleteMedicalVocabularyInput) transcribe.DeleteMedicalVocabularyRequest

	DeleteTranscriptionJobRequest(*transcribe.DeleteTranscriptionJobInput) transcribe.DeleteTranscriptionJobRequest

	DeleteVocabularyRequest(*transcribe.DeleteVocabularyInput) transcribe.DeleteVocabularyRequest

	DeleteVocabularyFilterRequest(*transcribe.DeleteVocabularyFilterInput) transcribe.DeleteVocabularyFilterRequest

	GetMedicalTranscriptionJobRequest(*transcribe.GetMedicalTranscriptionJobInput) transcribe.GetMedicalTranscriptionJobRequest

	GetMedicalVocabularyRequest(*transcribe.GetMedicalVocabularyInput) transcribe.GetMedicalVocabularyRequest

	GetTranscriptionJobRequest(*transcribe.GetTranscriptionJobInput) transcribe.GetTranscriptionJobRequest

	GetVocabularyRequest(*transcribe.GetVocabularyInput) transcribe.GetVocabularyRequest

	GetVocabularyFilterRequest(*transcribe.GetVocabularyFilterInput) transcribe.GetVocabularyFilterRequest

	ListMedicalTranscriptionJobsRequest(*transcribe.ListMedicalTranscriptionJobsInput) transcribe.ListMedicalTranscriptionJobsRequest

	ListMedicalVocabulariesRequest(*transcribe.ListMedicalVocabulariesInput) transcribe.ListMedicalVocabulariesRequest

	ListTranscriptionJobsRequest(*transcribe.ListTranscriptionJobsInput) transcribe.ListTranscriptionJobsRequest

	ListVocabulariesRequest(*transcribe.ListVocabulariesInput) transcribe.ListVocabulariesRequest

	ListVocabularyFiltersRequest(*transcribe.ListVocabularyFiltersInput) transcribe.ListVocabularyFiltersRequest

	StartMedicalTranscriptionJobRequest(*transcribe.StartMedicalTranscriptionJobInput) transcribe.StartMedicalTranscriptionJobRequest

	StartTranscriptionJobRequest(*transcribe.StartTranscriptionJobInput) transcribe.StartTranscriptionJobRequest

	UpdateMedicalVocabularyRequest(*transcribe.UpdateMedicalVocabularyInput) transcribe.UpdateMedicalVocabularyRequest

	UpdateVocabularyRequest(*transcribe.UpdateVocabularyInput) transcribe.UpdateVocabularyRequest

	UpdateVocabularyFilterRequest(*transcribe.UpdateVocabularyFilterInput) transcribe.UpdateVocabularyFilterRequest
}

var _ ClientAPI = (*transcribe.Client)(nil)
