// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateServerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
	// Required when Protocols is set to FTPS.
	//
	// To request a new public certificate, see Request a public certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To import an existing certificate into ACM, see Importing certificates into
	// ACM (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To request a private certificate to use FTPS through private IP addresses,
	// see Request a private certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html)
	// in the AWS Certificate Manager User Guide.
	//
	// Certificates with the following cryptographic algorithms and key sizes are
	// supported:
	//
	//    * 2048-bit RSA (RSA_2048)
	//
	//    * 4096-bit RSA (RSA_4096)
	//
	//    * Elliptic Prime Curve 256 bit (EC_prime256v1)
	//
	//    * Elliptic Prime Curve 384 bit (EC_secp384r1)
	//
	//    * Elliptic Prime Curve 521 bit (EC_secp521r1)
	//
	// The certificate must be a valid SSL/TLS X.509 version 3 certificate with
	// FQDN or IP address specified and information about the issuer.
	Certificate *string `type:"string"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your file transfer protocol-enabled server. When you host your endpoint within
	// your VPC, you can make it accessible only to resources within your VPC, or
	// you can attach Elastic IPs and make it accessible to clients over the internet.
	// Your VPC's default security groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of VPC endpoint that you want your file transfer protocol-enabled
	// server to connect to. You can choose to connect to the public internet or
	// a VPC endpoint. With a VPC endpoint, you can restrict access to your server
	// and resources only within your VPC.
	//
	// It is recommended that you use VPC as the EndpointType. With this endpoint
	// type, you have the option to directly associate up to three Elastic IPv4
	// addresses (BYO IP included) with your server's endpoint and use VPC security
	// groups to restrict traffic by the client's public IP address. This is not
	// possible with EndpointType set to VPC_ENDPOINT.
	EndpointType EndpointType `type:"string" enum:"true"`

	// The RSA private key as generated by the ssh-keygen -N "" -m PEM -f my-new-server-key
	// command.
	//
	// If you aren't planning to migrate existing users from an existing SFTP-enabled
	// server to a new server, don't update the host key. Accidentally changing
	// a server's host key can be disruptive.
	//
	// For more information, see Change the host key for your SFTP-enabled server
	// (https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key)
	// in the AWS Transfer Family User Guide.
	HostKey *string `type:"string" sensitive:"true"`

	// Required when IdentityProviderType is set to API_GATEWAY. Accepts an array
	// containing all of the information required to call a customer-supplied authentication
	// API, including the API Gateway URL. Not required when IdentityProviderType
	// is set to SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication for a file transfer protocol-enabled
	// server. The default value is SERVICE_MANAGED, which allows you to store and
	// access user credentials within the AWS Transfer Family service. Use the API_GATEWAY
	// value to integrate with an identity provider of your choosing. The API_GATEWAY
	// setting requires you to provide an API Gateway endpoint URL to call for authentication
	// using the IdentityProviderDetails parameter.
	IdentityProviderType IdentityProviderType `type:"string" enum:"true"`

	// Allows the service to write your users' activity to your Amazon CloudWatch
	// logs for monitoring and auditing purposes.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	//    SSH
	//
	//    * FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//
	//    * FTP (File Transfer Protocol): Unencrypted file transfer
	//
	// If you select FTPS, you must choose a certificate stored in AWS Certificate
	// Manager (ACM) which will be used to identify your server when clients connect
	// to it over FTPS.
	//
	// If Protocol includes either FTP or FTPS, then the EndpointType must be VPC
	// and the IdentityProviderType must be API_GATEWAY.
	//
	// If Protocol includes FTP, then AddressAllocationIds cannot be associated.
	//
	// If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
	// the IdentityProviderType can be set to SERVICE_MANAGED.
	Protocols []Protocol `min:"1" type:"list"`

	// Key-value pairs that can be used to group and search for file transfer protocol-enabled
	// servers.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateServerInput"}
	if s.LoggingRole != nil && len(*s.LoggingRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("LoggingRole", 20))
	}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Protocols", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(aws.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateServerOutput struct {
	_ struct{} `type:"structure"`

	// The service-assigned ID of the file transfer protocol-enabled server that
	// is created.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateServer = "CreateServer"

// CreateServerRequest returns a request value for making API operation for
// AWS Transfer Family.
//
// Instantiates an autoscaling virtual server based on the selected file transfer
// protocol in AWS. When you make updates to your file transfer protocol-enabled
// server or when you work with users, use the service-generated ServerId property
// that is assigned to the newly created server.
//
//    // Example sending a request using CreateServerRequest.
//    req := client.CreateServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Client) CreateServerRequest(input *CreateServerInput) CreateServerRequest {
	op := &aws.Operation{
		Name:       opCreateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerInput{}
	}

	req := c.newRequest(op, input, &CreateServerOutput{})

	return CreateServerRequest{Request: req, Input: input, Copy: c.CreateServerRequest}
}

// CreateServerRequest is the request type for the
// CreateServer API operation.
type CreateServerRequest struct {
	*aws.Request
	Input *CreateServerInput
	Copy  func(*CreateServerInput) CreateServerRequest
}

// Send marshals and sends the CreateServer API request.
func (r CreateServerRequest) Send(ctx context.Context) (*CreateServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateServerResponse{
		CreateServerOutput: r.Request.Data.(*CreateServerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateServerResponse is the response type for the
// CreateServer API operation.
type CreateServerResponse struct {
	*CreateServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateServer request.
func (r *CreateServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
