// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeServerInput"}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeServerOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the properties of a file transfer protocol-enabled server
	// with the ServerID you specified.
	//
	// Server is a required field
	Server *DescribedServer `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeServer = "DescribeServer"

// DescribeServerRequest returns a request value for making API operation for
// AWS Transfer Family.
//
// Describes a file transfer protocol-enabled server that you specify by passing
// the ServerId parameter.
//
// The response contains a description of a server's properties. When you set
// EndpointType to VPC, the response will contain the EndpointDetails.
//
//    // Example sending a request using DescribeServerRequest.
//    req := client.DescribeServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Client) DescribeServerRequest(input *DescribeServerInput) DescribeServerRequest {
	op := &aws.Operation{
		Name:       opDescribeServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServerInput{}
	}

	req := c.newRequest(op, input, &DescribeServerOutput{})

	return DescribeServerRequest{Request: req, Input: input, Copy: c.DescribeServerRequest}
}

// DescribeServerRequest is the request type for the
// DescribeServer API operation.
type DescribeServerRequest struct {
	*aws.Request
	Input *DescribeServerInput
	Copy  func(*DescribeServerInput) DescribeServerRequest
}

// Send marshals and sends the DescribeServer API request.
func (r DescribeServerRequest) Send(ctx context.Context) (*DescribeServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeServerResponse{
		DescribeServerOutput: r.Request.Data.(*DescribeServerOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeServerResponse is the response type for the
// DescribeServer API operation.
type DescribeServerResponse struct {
	*DescribeServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeServer request.
func (r *DescribeServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
