// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateServerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
	// Required when Protocols is set to FTPS.
	//
	// To request a new public certificate, see Request a public certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To import an existing certificate into ACM, see Importing certificates into
	// ACM (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To request a private certificate to use FTPS through private IP addresses,
	// see Request a private certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html)
	// in the AWS Certificate Manager User Guide.
	//
	// Certificates with the following cryptographic algorithms and key sizes are
	// supported:
	//
	//    * 2048-bit RSA (RSA_2048)
	//
	//    * 4096-bit RSA (RSA_4096)
	//
	//    * Elliptic Prime Curve 256 bit (EC_prime256v1)
	//
	//    * Elliptic Prime Curve 384 bit (EC_secp384r1)
	//
	//    * Elliptic Prime Curve 521 bit (EC_secp521r1)
	//
	// The certificate must be a valid SSL/TLS X.509 version 3 certificate with
	// FQDN or IP address specified and information about the issuer.
	Certificate *string `type:"string"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your file transfer protocol-enabled server. With a VPC endpoint, you can
	// restrict access to your server to resources only within your VPC. To control
	// incoming internet traffic, you will need to associate one or more Elastic
	// IP addresses with your server's endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of endpoint that you want your file transfer protocol-enabled server
	// to connect to. You can choose to connect to the public internet or a VPC
	// endpoint. With a VPC endpoint, you can restrict access to your server and
	// resources only within your VPC.
	//
	// It is recommended that you use VPC as the EndpointType. With this endpoint
	// type, you have the option to directly associate up to three Elastic IPv4
	// addresses (BYO IP included) with your server's endpoint and use VPC security
	// groups to restrict traffic by the client's public IP address. This is not
	// possible with EndpointType set to VPC_ENDPOINT.
	EndpointType EndpointType `type:"string" enum:"true"`

	// The RSA private key as generated by ssh-keygen -N "" -m PEM -f my-new-server-key.
	//
	// If you aren't planning to migrate existing users from an existing file transfer
	// protocol-enabled server to a new server, don't update the host key. Accidentally
	// changing a server's host key can be disruptive.
	//
	// For more information, see Change the host key for your SFTP-enabled server
	// (https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key)
	// in the AWS Transfer Family User Guide.
	HostKey *string `type:"string" sensitive:"true"`

	// An array containing all of the information required to call a customer's
	// authentication API method.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Changes the AWS Identity and Access Management (IAM) role that allows Amazon
	// S3 events to be logged in Amazon CloudWatch, turning logging on or off.
	LoggingRole *string `type:"string"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over
	//    SSH
	//
	//    * File Transfer Protocol Secure (FTPS): File transfer with TLS encryption
	//
	//    * File Transfer Protocol (FTP): Unencrypted file transfer
	//
	// If you select FTPS, you must choose a certificate stored in AWS Certificate
	// Manager (ACM) which will be used to identify your server when clients connect
	// to it over FTPS.
	//
	// If Protocol includes either FTP or FTPS, then the EndpointType must be VPC
	// and the IdentityProviderType must be API_GATEWAY.
	//
	// If Protocol includes FTP, then AddressAllocationIds cannot be associated.
	//
	// If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
	// the IdentityProviderType can be set to SERVICE_MANAGED.
	Protocols []Protocol `min:"1" type:"list"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that the user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateServerInput"}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Protocols", 1))
	}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerId", 19))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(aws.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateServerOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that the user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateServer = "UpdateServer"

// UpdateServerRequest returns a request value for making API operation for
// AWS Transfer Family.
//
// Updates the file transfer protocol-enabled server's properties after that
// server has been created.
//
// The UpdateServer call returns the ServerId of the server you updated.
//
//    // Example sending a request using UpdateServerRequest.
//    req := client.UpdateServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Client) UpdateServerRequest(input *UpdateServerInput) UpdateServerRequest {
	op := &aws.Operation{
		Name:       opUpdateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerInput{}
	}

	req := c.newRequest(op, input, &UpdateServerOutput{})

	return UpdateServerRequest{Request: req, Input: input, Copy: c.UpdateServerRequest}
}

// UpdateServerRequest is the request type for the
// UpdateServer API operation.
type UpdateServerRequest struct {
	*aws.Request
	Input *UpdateServerInput
	Copy  func(*UpdateServerInput) UpdateServerRequest
}

// Send marshals and sends the UpdateServer API request.
func (r UpdateServerRequest) Send(ctx context.Context) (*UpdateServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateServerResponse{
		UpdateServerOutput: r.Request.Data.(*UpdateServerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateServerResponse is the response type for the
// UpdateServer API operation.
type UpdateServerResponse struct {
	*UpdateServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateServer request.
func (r *UpdateServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
