// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package transferiface provides an interface to enable mocking the AWS Transfer Family service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package transferiface

import (
	"github.com/aws/aws-sdk-go-v2/service/transfer"
)

// ClientAPI provides an interface to enable mocking the
// transfer.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Transfer.
//    func myFunc(svc transferiface.ClientAPI) bool {
//        // Make svc.CreateServer request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := transfer.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        transferiface.ClientPI
//    }
//    func (m *mockClientClient) CreateServer(input *transfer.CreateServerInput) (*transfer.CreateServerOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateServerRequest(*transfer.CreateServerInput) transfer.CreateServerRequest

	CreateUserRequest(*transfer.CreateUserInput) transfer.CreateUserRequest

	DeleteServerRequest(*transfer.DeleteServerInput) transfer.DeleteServerRequest

	DeleteSshPublicKeyRequest(*transfer.DeleteSshPublicKeyInput) transfer.DeleteSshPublicKeyRequest

	DeleteUserRequest(*transfer.DeleteUserInput) transfer.DeleteUserRequest

	DescribeServerRequest(*transfer.DescribeServerInput) transfer.DescribeServerRequest

	DescribeUserRequest(*transfer.DescribeUserInput) transfer.DescribeUserRequest

	ImportSshPublicKeyRequest(*transfer.ImportSshPublicKeyInput) transfer.ImportSshPublicKeyRequest

	ListServersRequest(*transfer.ListServersInput) transfer.ListServersRequest

	ListTagsForResourceRequest(*transfer.ListTagsForResourceInput) transfer.ListTagsForResourceRequest

	ListUsersRequest(*transfer.ListUsersInput) transfer.ListUsersRequest

	StartServerRequest(*transfer.StartServerInput) transfer.StartServerRequest

	StopServerRequest(*transfer.StopServerInput) transfer.StopServerRequest

	TagResourceRequest(*transfer.TagResourceInput) transfer.TagResourceRequest

	TestIdentityProviderRequest(*transfer.TestIdentityProviderInput) transfer.TestIdentityProviderRequest

	UntagResourceRequest(*transfer.UntagResourceInput) transfer.UntagResourceRequest

	UpdateServerRequest(*transfer.UpdateServerInput) transfer.UpdateServerRequest

	UpdateUserRequest(*transfer.UpdateUserInput) transfer.UpdateUserRequest
}

var _ ClientAPI = (*transfer.Client)(nil)
