// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTextTranslationJobsInput struct {
	_ struct{} `type:"structure"`

	// The parameters that specify which batch translation jobs to retrieve. Filters
	// include job name, job status, and submission time. You can only set one filter
	// at a time.
	Filter *TextTranslationJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default value is
	// 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTextTranslationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTextTranslationJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTextTranslationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTextTranslationJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retreive the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// A list containing the properties of each job that is returned.
	TextTranslationJobPropertiesList []TextTranslationJobProperties `type:"list"`
}

// String returns the string representation
func (s ListTextTranslationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTextTranslationJobs = "ListTextTranslationJobs"

// ListTextTranslationJobsRequest returns a request value for making API operation for
// Amazon Translate.
//
// Gets a list of the batch translation jobs that you have submitted.
//
//    // Example sending a request using ListTextTranslationJobsRequest.
//    req := client.ListTextTranslationJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs
func (c *Client) ListTextTranslationJobsRequest(input *ListTextTranslationJobsInput) ListTextTranslationJobsRequest {
	op := &aws.Operation{
		Name:       opListTextTranslationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTextTranslationJobsInput{}
	}

	req := c.newRequest(op, input, &ListTextTranslationJobsOutput{})

	return ListTextTranslationJobsRequest{Request: req, Input: input, Copy: c.ListTextTranslationJobsRequest}
}

// ListTextTranslationJobsRequest is the request type for the
// ListTextTranslationJobs API operation.
type ListTextTranslationJobsRequest struct {
	*aws.Request
	Input *ListTextTranslationJobsInput
	Copy  func(*ListTextTranslationJobsInput) ListTextTranslationJobsRequest
}

// Send marshals and sends the ListTextTranslationJobs API request.
func (r ListTextTranslationJobsRequest) Send(ctx context.Context) (*ListTextTranslationJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTextTranslationJobsResponse{
		ListTextTranslationJobsOutput: r.Request.Data.(*ListTextTranslationJobsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTextTranslationJobsRequestPaginator returns a paginator for ListTextTranslationJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTextTranslationJobsRequest(input)
//   p := translate.NewListTextTranslationJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTextTranslationJobsPaginator(req ListTextTranslationJobsRequest) ListTextTranslationJobsPaginator {
	return ListTextTranslationJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTextTranslationJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTextTranslationJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTextTranslationJobsPaginator struct {
	aws.Pager
}

func (p *ListTextTranslationJobsPaginator) CurrentPage() *ListTextTranslationJobsOutput {
	return p.Pager.CurrentPage().(*ListTextTranslationJobsOutput)
}

// ListTextTranslationJobsResponse is the response type for the
// ListTextTranslationJobs API operation.
type ListTextTranslationJobsResponse struct {
	*ListTextTranslationJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTextTranslationJobs request.
func (r *ListTextTranslationJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
