// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type TranslateTextInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language of the source text. The language must
	// be a language supported by Amazon Translate. For a list of language codes,
	// see what-is-languages.
	//
	// To have Amazon Translate determine the source language of your text, you
	// can specify auto in the SourceLanguageCode field. If you specify auto, Amazon
	// Translate will call Amazon Comprehend (https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html)
	// to determine the source language.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code requested for the language of the target text. The language
	// must be a language supported by Amazon Translate.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The name of the terminology list file to be used in the TranslateText request.
	// You can use 1 terminology list at most in a TranslateText request. Terminology
	// lists can contain a maximum of 256 terms.
	TerminologyNames []string `type:"list"`

	// The text to translate. The text string can be a maximum of 5,000 bytes long.
	// Depending on your character set, this may be fewer than 5,000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TranslateTextInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranslateTextInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TranslateTextInput"}

	if s.SourceLanguageCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceLanguageCode", 2))
	}

	if s.TargetLanguageCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetLanguageCode"))
	}
	if s.TargetLanguageCode != nil && len(*s.TargetLanguageCode) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetLanguageCode", 2))
	}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TranslateTextOutput struct {
	_ struct{} `type:"structure"`

	// The names of the custom terminologies applied to the input text by Amazon
	// Translate for the translated text response.
	AppliedTerminologies []AppliedTerminology `type:"list"`

	// The language code for the language of the source text.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code for the language of the target text.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The translated text.
	//
	// TranslatedText is a required field
	TranslatedText *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TranslateTextOutput) String() string {
	return awsutil.Prettify(s)
}

const opTranslateText = "TranslateText"

// TranslateTextRequest returns a request value for making API operation for
// Amazon Translate.
//
// Translates input text from the source language to the target language. For
// a list of available languages and language codes, see what-is-languages.
//
//    // Example sending a request using TranslateTextRequest.
//    req := client.TranslateTextRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateText
func (c *Client) TranslateTextRequest(input *TranslateTextInput) TranslateTextRequest {
	op := &aws.Operation{
		Name:       opTranslateText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TranslateTextInput{}
	}

	req := c.newRequest(op, input, &TranslateTextOutput{})

	return TranslateTextRequest{Request: req, Input: input, Copy: c.TranslateTextRequest}
}

// TranslateTextRequest is the request type for the
// TranslateText API operation.
type TranslateTextRequest struct {
	*aws.Request
	Input *TranslateTextInput
	Copy  func(*TranslateTextInput) TranslateTextRequest
}

// Send marshals and sends the TranslateText API request.
func (r TranslateTextRequest) Send(ctx context.Context) (*TranslateTextResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TranslateTextResponse{
		TranslateTextOutput: r.Request.Data.(*TranslateTextOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TranslateTextResponse is the response type for the
// TranslateText API operation.
type TranslateTextResponse struct {
	*TranslateTextOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TranslateText request.
func (r *TranslateTextResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
