// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The WebACLId of the WebACL that you want to delete. WebACLId is returned
	// by CreateWebACL and by ListWebACLs.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWebACLInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteWebACLInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.WebACLId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteWebACL = "DeleteWebACL"

// DeleteWebACLRequest returns a request value for making API operation for
// AWS WAF.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Permanently deletes a WebACL. You can't delete a WebACL if it still contains
// any Rules.
//
// To delete a WebACL, perform the following steps:
//
// Update the WebACL to remove Rules, if any. For more information, see UpdateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteWebACL request.
//
// Submit a DeleteWebACL request.
//
//    // Example sending a request using DeleteWebACLRequest.
//    req := client.DeleteWebACLRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteWebACL
func (c *Client) DeleteWebACLRequest(input *DeleteWebACLInput) DeleteWebACLRequest {
	op := &aws.Operation{
		Name:       opDeleteWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWebACLInput{}
	}

	req := c.newRequest(op, input, &DeleteWebACLOutput{})

	return DeleteWebACLRequest{Request: req, Input: input, Copy: c.DeleteWebACLRequest}
}

// DeleteWebACLRequest is the request type for the
// DeleteWebACL API operation.
type DeleteWebACLRequest struct {
	*aws.Request
	Input *DeleteWebACLInput
	Copy  func(*DeleteWebACLInput) DeleteWebACLRequest
}

// Send marshals and sends the DeleteWebACL API request.
func (r DeleteWebACLRequest) Send(ctx context.Context) (*DeleteWebACLResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteWebACLResponse{
		DeleteWebACLOutput: r.Request.Data.(*DeleteWebACLOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteWebACLResponse is the response type for the
// DeleteWebACL API operation.
type DeleteWebACLResponse struct {
	*DeleteWebACLOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteWebACL request.
func (r *DeleteWebACLResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
