// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListWebACLsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of WebACL objects that you want AWS WAF to return for
	// this request. If you have more WebACL objects than the number that you specify
	// for Limit, the response includes a NextMarker value that you can use to get
	// another batch of WebACL objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more WebACL objects than the
	// number that you specify for Limit, AWS WAF returns a NextMarker value in
	// the response that allows you to list another group of WebACL objects. For
	// the second and subsequent ListWebACLs requests, specify the value of NextMarker
	// from the previous response to get information about another batch of WebACL
	// objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWebACLsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebACLsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListWebACLsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListWebACLsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more WebACL objects than the number that you specified for Limit
	// in the request, the response includes a NextMarker value. To list more WebACL
	// objects, submit another ListWebACLs request, and specify the NextMarker value
	// from the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of WebACLSummary objects.
	WebACLs []WebACLSummary `type:"list"`
}

// String returns the string representation
func (s ListWebACLsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListWebACLs = "ListWebACLs"

// ListWebACLsRequest returns a request value for making API operation for
// AWS WAF.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Returns an array of WebACLSummary objects in the response.
//
//    // Example sending a request using ListWebACLsRequest.
//    req := client.ListWebACLsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListWebACLs
func (c *Client) ListWebACLsRequest(input *ListWebACLsInput) ListWebACLsRequest {
	op := &aws.Operation{
		Name:       opListWebACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListWebACLsInput{}
	}

	req := c.newRequest(op, input, &ListWebACLsOutput{})

	return ListWebACLsRequest{Request: req, Input: input, Copy: c.ListWebACLsRequest}
}

// ListWebACLsRequest is the request type for the
// ListWebACLs API operation.
type ListWebACLsRequest struct {
	*aws.Request
	Input *ListWebACLsInput
	Copy  func(*ListWebACLsInput) ListWebACLsRequest
}

// Send marshals and sends the ListWebACLs API request.
func (r ListWebACLsRequest) Send(ctx context.Context) (*ListWebACLsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListWebACLsResponse{
		ListWebACLsOutput: r.Request.Data.(*ListWebACLsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListWebACLsResponse is the response type for the
// ListWebACLs API operation.
type ListWebACLsResponse struct {
	*ListWebACLsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListWebACLs request.
func (r *ListWebACLsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
