// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to delete. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteByteMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteByteMatchSetInput"}

	if s.ByteMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ByteMatchSetId"))
	}
	if s.ByteMatchSetId != nil && len(*s.ByteMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ByteMatchSetId", 1))
	}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteByteMatchSet = "DeleteByteMatchSet"

// DeleteByteMatchSetRequest returns a request value for making API operation for
// AWS WAF Regional.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Permanently deletes a ByteMatchSet. You can't delete a ByteMatchSet if it's
// still used in any Rules or if it still includes any ByteMatchTuple objects
// (any filters).
//
// If you just want to remove a ByteMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a ByteMatchSet, perform the following steps:
//
// Update the ByteMatchSet to remove filters, if any. For more information,
// see UpdateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteByteMatchSet request.
//
// Submit a DeleteByteMatchSet request.
//
//    // Example sending a request using DeleteByteMatchSetRequest.
//    req := client.DeleteByteMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteByteMatchSet
func (c *Client) DeleteByteMatchSetRequest(input *DeleteByteMatchSetInput) DeleteByteMatchSetRequest {
	op := &aws.Operation{
		Name:       opDeleteByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteByteMatchSetInput{}
	}

	req := c.newRequest(op, input, &DeleteByteMatchSetOutput{})

	return DeleteByteMatchSetRequest{Request: req, Input: input, Copy: c.DeleteByteMatchSetRequest}
}

// DeleteByteMatchSetRequest is the request type for the
// DeleteByteMatchSet API operation.
type DeleteByteMatchSetRequest struct {
	*aws.Request
	Input *DeleteByteMatchSetInput
	Copy  func(*DeleteByteMatchSetInput) DeleteByteMatchSetRequest
}

// Send marshals and sends the DeleteByteMatchSet API request.
func (r DeleteByteMatchSetRequest) Send(ctx context.Context) (*DeleteByteMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteByteMatchSetResponse{
		DeleteByteMatchSetOutput: r.Request.Data.(*DeleteByteMatchSetOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteByteMatchSetResponse is the response type for the
// DeleteByteMatchSet API operation.
type DeleteByteMatchSetResponse struct {
	*DeleteByteMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteByteMatchSet request.
func (r *DeleteByteMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
