// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RuleId of the Rule that you want to delete. RuleId is returned by CreateRule
	// and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRuleInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.RuleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest returns a request value for making API operation for
// AWS WAF Regional.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Permanently deletes a Rule. You can't delete a Rule if it's still used in
// any WebACL objects or if it still includes any predicates, such as ByteMatchSet
// objects.
//
// If you just want to remove a Rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a Rule from AWS WAF, perform the following steps:
//
// Update the Rule to remove predicates, if any. For more information, see UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRule request.
//
// Submit a DeleteRule request.
//
//    // Example sending a request using DeleteRuleRequest.
//    req := client.DeleteRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRule
func (c *Client) DeleteRuleRequest(input *DeleteRuleInput) DeleteRuleRequest {
	op := &aws.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	req := c.newRequest(op, input, &DeleteRuleOutput{})

	return DeleteRuleRequest{Request: req, Input: input, Copy: c.DeleteRuleRequest}
}

// DeleteRuleRequest is the request type for the
// DeleteRule API operation.
type DeleteRuleRequest struct {
	*aws.Request
	Input *DeleteRuleInput
	Copy  func(*DeleteRuleInput) DeleteRuleRequest
}

// Send marshals and sends the DeleteRule API request.
func (r DeleteRuleRequest) Send(ctx context.Context) (*DeleteRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRuleResponse{
		DeleteRuleOutput: r.Request.Data.(*DeleteRuleOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRuleResponse is the response type for the
// DeleteRule API operation.
type DeleteRuleResponse struct {
	*DeleteRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRule request.
func (r *DeleteRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
