// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListGeoMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of GeoMatchSet objects that you want AWS WAF to return
	// for this request. If you have more GeoMatchSet objects than the number you
	// specify for Limit, the response includes a NextMarker value that you can
	// use to get another batch of GeoMatchSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more GeoMatchSets than the
	// value of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of GeoMatchSet objects. For the second and subsequent
	// ListGeoMatchSets requests, specify the value of NextMarker from the previous
	// response to get information about another batch of GeoMatchSet objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeoMatchSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGeoMatchSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListGeoMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of GeoMatchSetSummary objects.
	GeoMatchSets []GeoMatchSetSummary `type:"list"`

	// If you have more GeoMatchSet objects than the number that you specified for
	// Limit in the request, the response includes a NextMarker value. To list more
	// GeoMatchSet objects, submit another ListGeoMatchSets request, and specify
	// the NextMarker value from the response in the NextMarker value in the next
	// request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListGeoMatchSets = "ListGeoMatchSets"

// ListGeoMatchSetsRequest returns a request value for making API operation for
// AWS WAF Regional.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Returns an array of GeoMatchSetSummary objects in the response.
//
//    // Example sending a request using ListGeoMatchSetsRequest.
//    req := client.ListGeoMatchSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListGeoMatchSets
func (c *Client) ListGeoMatchSetsRequest(input *ListGeoMatchSetsInput) ListGeoMatchSetsRequest {
	op := &aws.Operation{
		Name:       opListGeoMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGeoMatchSetsInput{}
	}

	req := c.newRequest(op, input, &ListGeoMatchSetsOutput{})

	return ListGeoMatchSetsRequest{Request: req, Input: input, Copy: c.ListGeoMatchSetsRequest}
}

// ListGeoMatchSetsRequest is the request type for the
// ListGeoMatchSets API operation.
type ListGeoMatchSetsRequest struct {
	*aws.Request
	Input *ListGeoMatchSetsInput
	Copy  func(*ListGeoMatchSetsInput) ListGeoMatchSetsRequest
}

// Send marshals and sends the ListGeoMatchSets API request.
func (r ListGeoMatchSetsRequest) Send(ctx context.Context) (*ListGeoMatchSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGeoMatchSetsResponse{
		ListGeoMatchSetsOutput: r.Request.Data.(*ListGeoMatchSetsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListGeoMatchSetsResponse is the response type for the
// ListGeoMatchSets API operation.
type ListGeoMatchSetsResponse struct {
	*ListGeoMatchSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGeoMatchSets request.
func (r *ListGeoMatchSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
