// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to associate with the web
	// ACL.
	//
	// The ARN must be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway stage: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Web ACL that you want to associate
	// with the resource.
	//
	// WebACLArn is a required field
	WebACLArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebACLInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateWebACLInput"}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 20))
	}

	if s.WebACLArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebACLArn"))
	}
	if s.WebACLArn != nil && len(*s.WebACLArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WebACLArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateWebACL = "AssociateWebACL"

// AssociateWebACLRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Associates a Web ACL with a regional application resource, to protect the
// resource. A regional application can be an Application Load Balancer (ALB)
// or an API Gateway stage.
//
// For AWS CloudFront, don't use this call. Instead, use your CloudFront distribution
// configuration. To associate a Web ACL, in the CloudFront call UpdateDistribution,
// set the web ACL ID to the Amazon Resource Name (ARN) of the Web ACL. For
// information, see UpdateDistribution (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
//
//    // Example sending a request using AssociateWebACLRequest.
//    req := client.AssociateWebACLRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL
func (c *Client) AssociateWebACLRequest(input *AssociateWebACLInput) AssociateWebACLRequest {
	op := &aws.Operation{
		Name:       opAssociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateWebACLInput{}
	}

	req := c.newRequest(op, input, &AssociateWebACLOutput{})

	return AssociateWebACLRequest{Request: req, Input: input, Copy: c.AssociateWebACLRequest}
}

// AssociateWebACLRequest is the request type for the
// AssociateWebACL API operation.
type AssociateWebACLRequest struct {
	*aws.Request
	Input *AssociateWebACLInput
	Copy  func(*AssociateWebACLInput) AssociateWebACLRequest
}

// Send marshals and sends the AssociateWebACL API request.
func (r AssociateWebACLRequest) Send(ctx context.Context) (*AssociateWebACLResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateWebACLResponse{
		AssociateWebACLOutput: r.Request.Data.(*AssociateWebACLOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateWebACLResponse is the response type for the
// AssociateWebACL API operation.
type AssociateWebACLResponse struct {
	*AssociateWebACLOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateWebACL request.
func (r *AssociateWebACLResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
