// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeManagedRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an AWS CloudFront distribution or for a regional
	// application. A regional application can be an Application Load Balancer (ALB)
	// or an API Gateway stage.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope Scope `type:"string" required:"true" enum:"true"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	//
	// VendorName is a required field
	VendorName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeManagedRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeManagedRuleGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeManagedRuleGroupInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Scope) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Scope"))
	}

	if s.VendorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VendorName"))
	}
	if s.VendorName != nil && len(*s.VendorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VendorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeManagedRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The web ACL capacity units (WCUs) required for this rule group. AWS WAF uses
	// web ACL capacity units (WCU) to calculate and control the operating resources
	// that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates
	// capacity differently for each rule type, to reflect each rule's relative
	// cost. Rule group capacity is fixed at creation, so users can plan their web
	// ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
	Capacity *int64 `min:"1" type:"long"`

	Rules []RuleSummary `type:"list"`
}

// String returns the string representation
func (s DescribeManagedRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeManagedRuleGroup = "DescribeManagedRuleGroup"

// DescribeManagedRuleGroupRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Provides high-level information for a managed rule group, including descriptions
// of the rules.
//
//    // Example sending a request using DescribeManagedRuleGroupRequest.
//    req := client.DescribeManagedRuleGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup
func (c *Client) DescribeManagedRuleGroupRequest(input *DescribeManagedRuleGroupInput) DescribeManagedRuleGroupRequest {
	op := &aws.Operation{
		Name:       opDescribeManagedRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeManagedRuleGroupInput{}
	}

	req := c.newRequest(op, input, &DescribeManagedRuleGroupOutput{})

	return DescribeManagedRuleGroupRequest{Request: req, Input: input, Copy: c.DescribeManagedRuleGroupRequest}
}

// DescribeManagedRuleGroupRequest is the request type for the
// DescribeManagedRuleGroup API operation.
type DescribeManagedRuleGroupRequest struct {
	*aws.Request
	Input *DescribeManagedRuleGroupInput
	Copy  func(*DescribeManagedRuleGroupInput) DescribeManagedRuleGroupRequest
}

// Send marshals and sends the DescribeManagedRuleGroup API request.
func (r DescribeManagedRuleGroupRequest) Send(ctx context.Context) (*DescribeManagedRuleGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeManagedRuleGroupResponse{
		DescribeManagedRuleGroupOutput: r.Request.Data.(*DescribeManagedRuleGroupOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeManagedRuleGroupResponse is the response type for the
// DescribeManagedRuleGroup API operation.
type DescribeManagedRuleGroupResponse struct {
	*DescribeManagedRuleGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeManagedRuleGroup request.
func (r *DescribeManagedRuleGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
