// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSampledRequestsInput struct {
	_ struct{} `type:"structure"`

	// The number of requests that you want AWS WAF to return from among the first
	// 5,000 requests that your AWS resource received during the time range. If
	// your resource received fewer requests than the value of MaxItems, GetSampledRequests
	// returns information about all of them.
	//
	// MaxItems is a required field
	MaxItems *int64 `min:"1" type:"long" required:"true"`

	// The metric name assigned to the Rule or RuleGroup for which you want a sample
	// of requests.
	//
	// RuleMetricName is a required field
	RuleMetricName *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an AWS CloudFront distribution or for a regional
	// application. A regional application can be an Application Load Balancer (ALB)
	// or an API Gateway stage.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope Scope `type:"string" required:"true" enum:"true"`

	// The start date and time and the end date and time of the range for which
	// you want GetSampledRequests to return a sample of requests. You must specify
	// the times in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z". You can specify
	// any time range in the previous three hours.
	//
	// TimeWindow is a required field
	TimeWindow *TimeWindow `type:"structure" required:"true"`

	// The Amazon resource name (ARN) of the WebACL for which you want a sample
	// of requests.
	//
	// WebAclArn is a required field
	WebAclArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSampledRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSampledRequestsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSampledRequestsInput"}

	if s.MaxItems == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxItems"))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if s.RuleMetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleMetricName"))
	}
	if s.RuleMetricName != nil && len(*s.RuleMetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleMetricName", 1))
	}
	if len(s.Scope) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Scope"))
	}

	if s.TimeWindow == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeWindow"))
	}

	if s.WebAclArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebAclArn"))
	}
	if s.WebAclArn != nil && len(*s.WebAclArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WebAclArn", 20))
	}
	if s.TimeWindow != nil {
		if err := s.TimeWindow.Validate(); err != nil {
			invalidParams.AddNested("TimeWindow", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSampledRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The total number of requests from which GetSampledRequests got a sample of
	// MaxItems requests. If PopulationSize is less than MaxItems, the sample includes
	// every request that your AWS resource received during the specified time range.
	PopulationSize *int64 `type:"long"`

	// A complex type that contains detailed information about each of the requests
	// in the sample.
	SampledRequests []SampledHTTPRequest `type:"list"`

	// Usually, TimeWindow is the time range that you specified in the GetSampledRequests
	// request. However, if your AWS resource received more than 5,000 requests
	// during the time range that you specified in the request, GetSampledRequests
	// returns the time range for the first 5,000 requests. Times are in Coordinated
	// Universal Time (UTC) format.
	TimeWindow *TimeWindow `type:"structure"`
}

// String returns the string representation
func (s GetSampledRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSampledRequests = "GetSampledRequests"

// GetSampledRequestsRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Gets detailed information about a specified number of requests--a sample--that
// AWS WAF randomly selects from among the first 5,000 requests that your AWS
// resource received during a time range that you choose. You can specify a
// sample size of up to 500 requests, and you can specify any time range in
// the previous three hours.
//
// GetSampledRequests returns a time range, which is usually the time range
// that you specified. However, if your resource (such as a CloudFront distribution)
// received 5,000 requests before the specified time range elapsed, GetSampledRequests
// returns an updated time range. This new time range indicates the actual period
// during which AWS WAF selected the requests in the sample.
//
//    // Example sending a request using GetSampledRequestsRequest.
//    req := client.GetSampledRequestsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests
func (c *Client) GetSampledRequestsRequest(input *GetSampledRequestsInput) GetSampledRequestsRequest {
	op := &aws.Operation{
		Name:       opGetSampledRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSampledRequestsInput{}
	}

	req := c.newRequest(op, input, &GetSampledRequestsOutput{})

	return GetSampledRequestsRequest{Request: req, Input: input, Copy: c.GetSampledRequestsRequest}
}

// GetSampledRequestsRequest is the request type for the
// GetSampledRequests API operation.
type GetSampledRequestsRequest struct {
	*aws.Request
	Input *GetSampledRequestsInput
	Copy  func(*GetSampledRequestsInput) GetSampledRequestsRequest
}

// Send marshals and sends the GetSampledRequests API request.
func (r GetSampledRequestsRequest) Send(ctx context.Context) (*GetSampledRequestsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSampledRequestsResponse{
		GetSampledRequestsOutput: r.Request.Data.(*GetSampledRequestsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSampledRequestsResponse is the response type for the
// GetSampledRequests API operation.
type GetSampledRequestsResponse struct {
	*GetSampledRequestsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSampledRequests request.
func (r *GetSampledRequestsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
