// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// A description of the set that helps with identification. You cannot change
	// the description of a set after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. AWS WAF returns a token to your get
	// and list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. AWS WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the set. You cannot change the name after you create the set.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// RegularExpressionList is a required field
	RegularExpressionList []Regex `type:"list" required:"true"`

	// Specifies whether this is for an AWS CloudFront distribution or for a regional
	// application. A regional application can be an Application Load Balancer (ALB)
	// or an API Gateway stage.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope Scope `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRegexPatternSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRegexPatternSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.LockToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LockToken", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RegularExpressionList == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegularExpressionList"))
	}
	if len(s.Scope) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Scope"))
	}
	if s.RegularExpressionList != nil {
		for i, v := range s.RegularExpressionList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RegularExpressionList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. AWS WAF returns this token to your update
	// requests. You use NextLockToken in the same manner as you use LockToken.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRegexPatternSet = "UpdateRegexPatternSet"

// UpdateRegexPatternSetRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Updates the specified RegexPatternSet.
//
//    // Example sending a request using UpdateRegexPatternSetRequest.
//    req := client.UpdateRegexPatternSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet
func (c *Client) UpdateRegexPatternSetRequest(input *UpdateRegexPatternSetInput) UpdateRegexPatternSetRequest {
	op := &aws.Operation{
		Name:       opUpdateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRegexPatternSetInput{}
	}

	req := c.newRequest(op, input, &UpdateRegexPatternSetOutput{})

	return UpdateRegexPatternSetRequest{Request: req, Input: input, Copy: c.UpdateRegexPatternSetRequest}
}

// UpdateRegexPatternSetRequest is the request type for the
// UpdateRegexPatternSet API operation.
type UpdateRegexPatternSetRequest struct {
	*aws.Request
	Input *UpdateRegexPatternSetInput
	Copy  func(*UpdateRegexPatternSetInput) UpdateRegexPatternSetRequest
}

// Send marshals and sends the UpdateRegexPatternSet API request.
func (r UpdateRegexPatternSetRequest) Send(ctx context.Context) (*UpdateRegexPatternSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRegexPatternSetResponse{
		UpdateRegexPatternSetOutput: r.Request.Data.(*UpdateRegexPatternSetOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRegexPatternSetResponse is the response type for the
// UpdateRegexPatternSet API operation.
type UpdateRegexPatternSetResponse struct {
	*UpdateRegexPatternSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRegexPatternSet request.
func (r *UpdateRegexPatternSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
