// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AddResourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The notification options.
	NotificationOptions *NotificationOptions `type:"structure"`

	// The users, groups, or organization being granted permission.
	//
	// Principals is a required field
	Principals []SharePrincipal `type:"list" required:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddResourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddResourcePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddResourcePermissionsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.Principals == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principals"))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Principals != nil {
		for i, v := range s.Principals {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Principals", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddResourcePermissionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.NotificationOptions != nil {
		v := s.NotificationOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NotificationOptions", v, metadata)
	}
	if s.Principals != nil {
		v := s.Principals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Principals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ResourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AddResourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The share results.
	ShareResults []ShareResult `type:"list"`
}

// String returns the string representation
func (s AddResourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddResourcePermissionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ShareResults != nil {
		v := s.ShareResults

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ShareResults", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opAddResourcePermissions = "AddResourcePermissions"

// AddResourcePermissionsRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Creates a set of permissions for the specified folder or document. The resource
// permissions are overwritten if the principals already have different permissions.
//
//    // Example sending a request using AddResourcePermissionsRequest.
//    req := client.AddResourcePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions
func (c *Client) AddResourcePermissionsRequest(input *AddResourcePermissionsInput) AddResourcePermissionsRequest {
	op := &aws.Operation{
		Name:       opAddResourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/resources/{ResourceId}/permissions",
	}

	if input == nil {
		input = &AddResourcePermissionsInput{}
	}

	req := c.newRequest(op, input, &AddResourcePermissionsOutput{})

	return AddResourcePermissionsRequest{Request: req, Input: input, Copy: c.AddResourcePermissionsRequest}
}

// AddResourcePermissionsRequest is the request type for the
// AddResourcePermissions API operation.
type AddResourcePermissionsRequest struct {
	*aws.Request
	Input *AddResourcePermissionsInput
	Copy  func(*AddResourcePermissionsInput) AddResourcePermissionsRequest
}

// Send marshals and sends the AddResourcePermissions API request.
func (r AddResourcePermissionsRequest) Send(ctx context.Context) (*AddResourcePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddResourcePermissionsResponse{
		AddResourcePermissionsOutput: r.Request.Data.(*AddResourcePermissionsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddResourcePermissionsResponse is the response type for the
// AddResourcePermissions API operation.
type AddResourcePermissionsResponse struct {
	*AddResourcePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddResourcePermissions request.
func (r *AddResourcePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
