// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeactivateUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivateUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeactivateUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeactivateUserInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeactivateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeactivateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeactivateUserOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeactivateUser = "DeactivateUser"

// DeactivateUserRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Deactivates the specified user, which revokes the user's access to Amazon
// WorkDocs.
//
//    // Example sending a request using DeactivateUserRequest.
//    req := client.DeactivateUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser
func (c *Client) DeactivateUserRequest(input *DeactivateUserInput) DeactivateUserRequest {
	op := &aws.Operation{
		Name:       opDeactivateUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/users/{UserId}/activation",
	}

	if input == nil {
		input = &DeactivateUserInput{}
	}

	req := c.newRequest(op, input, &DeactivateUserOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeactivateUserRequest{Request: req, Input: input, Copy: c.DeactivateUserRequest}
}

// DeactivateUserRequest is the request type for the
// DeactivateUser API operation.
type DeactivateUserRequest struct {
	*aws.Request
	Input *DeactivateUserInput
	Copy  func(*DeactivateUserInput) DeactivateUserRequest
}

// Send marshals and sends the DeactivateUser API request.
func (r DeactivateUserRequest) Send(ctx context.Context) (*DeactivateUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeactivateUserResponse{
		DeactivateUserOutput: r.Request.Data.(*DeactivateUserOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeactivateUserResponse is the response type for the
// DeactivateUser API operation.
type DeactivateUserResponse struct {
	*DeactivateUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeactivateUser request.
func (r *DeactivateUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
