// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteFolderInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFolderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFolderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFolderInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.FolderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFolderInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FolderId != nil {
		v := *s.FolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteFolderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFolderOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFolder = "DeleteFolder"

// DeleteFolderRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Permanently deletes the specified folder and its contents.
//
//    // Example sending a request using DeleteFolderRequest.
//    req := client.DeleteFolderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder
func (c *Client) DeleteFolderRequest(input *DeleteFolderInput) DeleteFolderRequest {
	op := &aws.Operation{
		Name:       opDeleteFolder,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/folders/{FolderId}",
	}

	if input == nil {
		input = &DeleteFolderInput{}
	}

	req := c.newRequest(op, input, &DeleteFolderOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteFolderRequest{Request: req, Input: input, Copy: c.DeleteFolderRequest}
}

// DeleteFolderRequest is the request type for the
// DeleteFolder API operation.
type DeleteFolderRequest struct {
	*aws.Request
	Input *DeleteFolderInput
	Copy  func(*DeleteFolderInput) DeleteFolderRequest
}

// Send marshals and sends the DeleteFolder API request.
func (r DeleteFolderRequest) Send(ctx context.Context) (*DeleteFolderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFolderResponse{
		DeleteFolderOutput: r.Request.Data.(*DeleteFolderOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFolderResponse is the response type for the
// DeleteFolder API operation.
type DeleteFolderResponse struct {
	*DeleteFolderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFolder request.
func (r *DeleteFolderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
