// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeResourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The maximum number of items to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the principal to filter permissions by.
	PrincipalId *string `location:"querystring" locationName:"principalId" min:"1" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeResourcePermissionsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PrincipalId", 1))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeResourcePermissionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ResourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeResourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`

	// The principals.
	Principals []Principal `type:"list"`
}

// String returns the string representation
func (s DescribeResourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeResourcePermissionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Principals != nil {
		v := s.Principals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Principals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeResourcePermissions = "DescribeResourcePermissions"

// DescribeResourcePermissionsRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Describes the permissions of a specified resource.
//
//    // Example sending a request using DescribeResourcePermissionsRequest.
//    req := client.DescribeResourcePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions
func (c *Client) DescribeResourcePermissionsRequest(input *DescribeResourcePermissionsInput) DescribeResourcePermissionsRequest {
	op := &aws.Operation{
		Name:       opDescribeResourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/resources/{ResourceId}/permissions",
	}

	if input == nil {
		input = &DescribeResourcePermissionsInput{}
	}

	req := c.newRequest(op, input, &DescribeResourcePermissionsOutput{})

	return DescribeResourcePermissionsRequest{Request: req, Input: input, Copy: c.DescribeResourcePermissionsRequest}
}

// DescribeResourcePermissionsRequest is the request type for the
// DescribeResourcePermissions API operation.
type DescribeResourcePermissionsRequest struct {
	*aws.Request
	Input *DescribeResourcePermissionsInput
	Copy  func(*DescribeResourcePermissionsInput) DescribeResourcePermissionsRequest
}

// Send marshals and sends the DescribeResourcePermissions API request.
func (r DescribeResourcePermissionsRequest) Send(ctx context.Context) (*DescribeResourcePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeResourcePermissionsResponse{
		DescribeResourcePermissionsOutput: r.Request.Data.(*DescribeResourcePermissionsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeResourcePermissionsResponse is the response type for the
// DescribeResourcePermissions API operation.
type DescribeResourcePermissionsResponse struct {
	*DescribeResourcePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeResourcePermissions request.
func (r *DescribeResourcePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
