// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetCurrentUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token.
	//
	// AuthenticationToken is a required field
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s GetCurrentUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCurrentUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCurrentUserInput"}

	if s.AuthenticationToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthenticationToken"))
	}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCurrentUserInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetCurrentUserOutput struct {
	_ struct{} `type:"structure"`

	// Metadata of the user.
	User *User `type:"structure"`
}

// String returns the string representation
func (s GetCurrentUserOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCurrentUserOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

const opGetCurrentUser = "GetCurrentUser"

// GetCurrentUserRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Retrieves details of the current user for whom the authentication token was
// generated. This is not a valid action for SigV4 (administrative API) clients.
//
// This action requires an authentication token. To get an authentication token,
// register an application with Amazon WorkDocs. For more information, see Authentication
// and Access Control for User Applications (https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html)
// in the Amazon WorkDocs Developer Guide.
//
//    // Example sending a request using GetCurrentUserRequest.
//    req := client.GetCurrentUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser
func (c *Client) GetCurrentUserRequest(input *GetCurrentUserInput) GetCurrentUserRequest {
	op := &aws.Operation{
		Name:       opGetCurrentUser,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/me",
	}

	if input == nil {
		input = &GetCurrentUserInput{}
	}

	req := c.newRequest(op, input, &GetCurrentUserOutput{})

	return GetCurrentUserRequest{Request: req, Input: input, Copy: c.GetCurrentUserRequest}
}

// GetCurrentUserRequest is the request type for the
// GetCurrentUser API operation.
type GetCurrentUserRequest struct {
	*aws.Request
	Input *GetCurrentUserInput
	Copy  func(*GetCurrentUserInput) GetCurrentUserRequest
}

// Send marshals and sends the GetCurrentUser API request.
func (r GetCurrentUserRequest) Send(ctx context.Context) (*GetCurrentUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCurrentUserResponse{
		GetCurrentUserOutput: r.Request.Data.(*GetCurrentUserOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCurrentUserResponse is the response type for the
// GetCurrentUser API operation.
type GetCurrentUserResponse struct {
	*GetCurrentUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCurrentUser request.
func (r *GetCurrentUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
