// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes the activity information.
type Activity struct {
	_ struct{} `type:"structure"`

	// Metadata of the commenting activity. This is an optional field and is filled
	// for commenting activities.
	CommentMetadata *CommentMetadata `type:"structure"`

	// The user who performed the action.
	Initiator *UserMetadata `type:"structure"`

	// Indicates whether an activity is indirect or direct. An indirect activity
	// results from a direct activity performed on a parent resource. For example,
	// sharing a parent folder (the direct activity) shares all of the subfolders
	// and documents within the parent folder (the indirect activity).
	IsIndirectActivity *bool `type:"boolean"`

	// The ID of the organization.
	OrganizationId *string `min:"1" type:"string"`

	// The original parent of the resource. This is an optional field and is filled
	// for move activities.
	OriginalParent *ResourceMetadata `type:"structure"`

	// The list of users or groups impacted by this action. This is an optional
	// field and is filled for the following sharing activities: DOCUMENT_SHARED,
	// DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.
	Participants *Participants `type:"structure"`

	// The metadata of the resource involved in the user action.
	ResourceMetadata *ResourceMetadata `type:"structure"`

	// The timestamp when the action was performed.
	TimeStamp *time.Time `type:"timestamp"`

	// The activity type.
	Type ActivityType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Activity) MarshalFields(e protocol.FieldEncoder) error {
	if s.CommentMetadata != nil {
		v := s.CommentMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CommentMetadata", v, metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.IsIndirectActivity != nil {
		v := *s.IsIndirectActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsIndirectActivity", protocol.BoolValue(v), metadata)
	}
	if s.OrganizationId != nil {
		v := *s.OrganizationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OrganizationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginalParent != nil {
		v := s.OriginalParent

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OriginalParent", v, metadata)
	}
	if s.Participants != nil {
		v := s.Participants

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Participants", v, metadata)
	}
	if s.ResourceMetadata != nil {
		v := s.ResourceMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ResourceMetadata", v, metadata)
	}
	if s.TimeStamp != nil {
		v := *s.TimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a comment.
type Comment struct {
	_ struct{} `type:"structure"`

	// The ID of the comment.
	//
	// CommentId is a required field
	CommentId *string `min:"1" type:"string" required:"true"`

	// The details of the user who made the comment.
	Contributor *User `type:"structure"`

	// The time that the comment was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the parent comment.
	ParentId *string `min:"1" type:"string"`

	// If the comment is a reply to another user's comment, this field contains
	// the user ID of the user being replied to.
	RecipientId *string `min:"1" type:"string"`

	// The status of the comment.
	Status CommentStatusType `type:"string" enum:"true"`

	// The text of the comment.
	Text *string `min:"1" type:"string" sensitive:"true"`

	// The ID of the root comment in the thread.
	ThreadId *string `min:"1" type:"string"`

	// The visibility of the comment. Options are either PRIVATE, where the comment
	// is visible only to the comment author and document owner and co-owners, or
	// PUBLIC, where the comment is visible to document owners, co-owners, and contributors.
	Visibility CommentVisibilityType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Comment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Comment) MarshalFields(e protocol.FieldEncoder) error {
	if s.CommentId != nil {
		v := *s.CommentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CommentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Contributor != nil {
		v := s.Contributor

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Contributor", v, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ParentId != nil {
		v := *s.ParentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecipientId != nil {
		v := *s.RecipientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecipientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreadId != nil {
		v := *s.ThreadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThreadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Visibility) > 0 {
		v := s.Visibility

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Visibility", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes the metadata of a comment.
type CommentMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the comment.
	CommentId *string `min:"1" type:"string"`

	// The status of the comment.
	CommentStatus CommentStatusType `type:"string" enum:"true"`

	// The user who made the comment.
	Contributor *User `type:"structure"`

	// The timestamp that the comment was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the user being replied to.
	RecipientId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CommentMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CommentMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CommentId != nil {
		v := *s.CommentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CommentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CommentStatus) > 0 {
		v := s.CommentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CommentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Contributor != nil {
		v := s.Contributor

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Contributor", v, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.RecipientId != nil {
		v := *s.RecipientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecipientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the document.
type DocumentMetadata struct {
	_ struct{} `type:"structure"`

	// The time when the document was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the creator.
	CreatorId *string `min:"1" type:"string"`

	// The ID of the document.
	Id *string `min:"1" type:"string"`

	// List of labels on the document.
	Labels []string `type:"list"`

	// The latest version of the document.
	LatestVersionMetadata *DocumentVersionMetadata `type:"structure"`

	// The time when the document was updated.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state.
	ResourceState ResourceStateType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DocumentMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreatorId != nil {
		v := *s.CreatorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Labels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LatestVersionMetadata != nil {
		v := s.LatestVersionMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LatestVersionMetadata", v, metadata)
	}
	if s.ModifiedTimestamp != nil {
		v := *s.ModifiedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModifiedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ParentFolderId != nil {
		v := *s.ParentFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceState) > 0 {
		v := s.ResourceState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a version of a document.
type DocumentVersionMetadata struct {
	_ struct{} `type:"structure"`

	// The timestamp when the content of the document was originally created.
	ContentCreatedTimestamp *time.Time `type:"timestamp"`

	// The timestamp when the content of the document was modified.
	ContentModifiedTimestamp *time.Time `type:"timestamp"`

	// The content type of the document.
	ContentType *string `min:"1" type:"string"`

	// The timestamp when the document was first uploaded.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the creator.
	CreatorId *string `min:"1" type:"string"`

	// The ID of the version.
	Id *string `min:"1" type:"string"`

	// The timestamp when the document was last uploaded.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The name of the version.
	Name *string `min:"1" type:"string"`

	// The signature of the document.
	Signature *string `type:"string"`

	// The size of the document, in bytes.
	Size *int64 `type:"long"`

	// The source of the document.
	Source map[string]string `type:"map"`

	// The status of the document.
	Status DocumentStatusType `type:"string" enum:"true"`

	// The thumbnail of the document.
	Thumbnail map[string]string `type:"map"`
}

// String returns the string representation
func (s DocumentVersionMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DocumentVersionMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentCreatedTimestamp != nil {
		v := *s.ContentCreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentCreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ContentModifiedTimestamp != nil {
		v := *s.ContentModifiedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentModifiedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreatorId != nil {
		v := *s.CreatorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModifiedTimestamp != nil {
		v := *s.ModifiedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModifiedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Signature != nil {
		v := *s.Signature

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Signature", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if s.Source != nil {
		v := s.Source

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Source", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Thumbnail != nil {
		v := s.Thumbnail

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Thumbnail", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Describes a folder.
type FolderMetadata struct {
	_ struct{} `type:"structure"`

	// The time when the folder was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the creator.
	CreatorId *string `min:"1" type:"string"`

	// The ID of the folder.
	Id *string `min:"1" type:"string"`

	// List of labels on the folder.
	Labels []string `type:"list"`

	// The size of the latest version of the folder metadata.
	LatestVersionSize *int64 `type:"long"`

	// The time when the folder was updated.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The name of the folder.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state of the folder.
	ResourceState ResourceStateType `type:"string" enum:"true"`

	// The unique identifier created from the subfolders and documents of the folder.
	Signature *string `type:"string"`

	// The size of the folder metadata.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s FolderMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FolderMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreatorId != nil {
		v := *s.CreatorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Labels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LatestVersionSize != nil {
		v := *s.LatestVersionSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersionSize", protocol.Int64Value(v), metadata)
	}
	if s.ModifiedTimestamp != nil {
		v := *s.ModifiedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModifiedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentFolderId != nil {
		v := *s.ParentFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceState) > 0 {
		v := s.ResourceState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Signature != nil {
		v := *s.Signature

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Signature", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes the metadata of a user group.
type GroupMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the user group.
	Id *string `min:"1" type:"string"`

	// The name of the group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Set of options which defines notification preferences of given action.
type NotificationOptions struct {
	_ struct{} `type:"structure"`

	// Text value to be included in the email body.
	EmailMessage *string `type:"string" sensitive:"true"`

	// Boolean value to indicate an email notification should be sent to the receipients.
	SendEmail *bool `type:"boolean"`
}

// String returns the string representation
func (s NotificationOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailMessage != nil {
		v := *s.EmailMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SendEmail != nil {
		v := *s.SendEmail

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SendEmail", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Describes the users or user groups.
type Participants struct {
	_ struct{} `type:"structure"`

	// The list of user groups.
	Groups []GroupMetadata `type:"list"`

	// The list of users.
	Users []UserMetadata `type:"list"`
}

// String returns the string representation
func (s Participants) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Participants) MarshalFields(e protocol.FieldEncoder) error {
	if s.Groups != nil {
		v := s.Groups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Groups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Users != nil {
		v := s.Users

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Users", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes the permissions.
type PermissionInfo struct {
	_ struct{} `type:"structure"`

	// The role of the user.
	Role RoleType `type:"string" enum:"true"`

	// The type of permissions.
	Type RolePermissionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s PermissionInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PermissionInfo) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a resource.
type Principal struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	Id *string `min:"1" type:"string"`

	// The permission information for the resource.
	Roles []PermissionInfo `type:"list"`

	// The type of resource.
	Type PrincipalType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Principal) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Roles != nil {
		v := s.Roles

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Roles", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes the metadata of a resource.
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	Id *string `min:"1" type:"string"`

	// The name of the resource.
	Name *string `min:"1" type:"string"`

	// The original name of the resource before a rename operation.
	OriginalName *string `min:"1" type:"string"`

	// The owner of the resource.
	Owner *UserMetadata `type:"structure"`

	// The parent ID of the resource before a rename operation.
	ParentId *string `min:"1" type:"string"`

	// The type of resource.
	Type ResourceType `type:"string" enum:"true"`

	// The version ID of the resource. This is an optional field and is filled for
	// action on document version.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginalName != nil {
		v := *s.OriginalName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginalName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.ParentId != nil {
		v := *s.ParentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the path information of a resource.
type ResourcePath struct {
	_ struct{} `type:"structure"`

	// The components of the resource path.
	Components []ResourcePathComponent `type:"list"`
}

// String returns the string representation
func (s ResourcePath) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourcePath) MarshalFields(e protocol.FieldEncoder) error {
	if s.Components != nil {
		v := s.Components

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Components", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes the resource path.
type ResourcePathComponent struct {
	_ struct{} `type:"structure"`

	// The ID of the resource path.
	Id *string `min:"1" type:"string"`

	// The name of the resource path.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourcePathComponent) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourcePathComponent) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the recipient type and ID, if available.
type SharePrincipal struct {
	_ struct{} `type:"structure"`

	// The ID of the recipient.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The role of the recipient.
	//
	// Role is a required field
	Role RoleType `type:"string" required:"true" enum:"true"`

	// The type of the recipient.
	//
	// Type is a required field
	Type PrincipalType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SharePrincipal) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePrincipal) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SharePrincipal"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if len(s.Role) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SharePrincipal) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes the share results of a resource.
type ShareResult struct {
	_ struct{} `type:"structure"`

	// The ID of the invited user.
	InviteePrincipalId *string `min:"1" type:"string"`

	// The ID of the principal.
	PrincipalId *string `min:"1" type:"string"`

	// The role.
	Role RoleType `type:"string" enum:"true"`

	// The ID of the resource that was shared.
	ShareId *string `min:"1" type:"string"`

	// The status.
	Status ShareStatusType `type:"string" enum:"true"`

	// The status message.
	StatusMessage *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ShareResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ShareResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.InviteePrincipalId != nil {
		v := *s.InviteePrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InviteePrincipalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrincipalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ShareId != nil {
		v := *s.ShareId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ShareId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the storage for a user.
type StorageRuleType struct {
	_ struct{} `type:"structure"`

	// The amount of storage allocated, in bytes.
	StorageAllocatedInBytes *int64 `type:"long"`

	// The type of storage.
	StorageType StorageType `type:"string" enum:"true"`
}

// String returns the string representation
func (s StorageRuleType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageRuleType) MarshalFields(e protocol.FieldEncoder) error {
	if s.StorageAllocatedInBytes != nil {
		v := *s.StorageAllocatedInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageAllocatedInBytes", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageType) > 0 {
		v := s.StorageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a subscription.
type Subscription struct {
	_ struct{} `type:"structure"`

	// The endpoint of the subscription.
	EndPoint *string `min:"1" type:"string"`

	// The protocol of the subscription.
	Protocol SubscriptionProtocolType `type:"string" enum:"true"`

	// The ID of the subscription.
	SubscriptionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Subscription) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndPoint != nil {
		v := *s.EndPoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndPoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SubscriptionId != nil {
		v := *s.SubscriptionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubscriptionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the upload.
type UploadMetadata struct {
	_ struct{} `type:"structure"`

	// The signed headers.
	SignedHeaders map[string]string `type:"map"`

	// The URL of the upload.
	UploadUrl *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s UploadMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.SignedHeaders != nil {
		v := s.SignedHeaders

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "SignedHeaders", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UploadUrl != nil {
		v := *s.UploadUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a user.
type User struct {
	_ struct{} `type:"structure"`

	// The time when the user was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The email address of the user.
	EmailAddress *string `min:"1" type:"string"`

	// The given name of the user.
	GivenName *string `min:"1" type:"string"`

	// The ID of the user.
	Id *string `min:"1" type:"string"`

	// The locale of the user.
	Locale LocaleType `type:"string" enum:"true"`

	// The time when the user was modified.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The ID of the organization.
	OrganizationId *string `min:"1" type:"string"`

	// The ID of the recycle bin folder.
	RecycleBinFolderId *string `min:"1" type:"string"`

	// The ID of the root folder.
	RootFolderId *string `min:"1" type:"string"`

	// The status of the user.
	Status UserStatusType `type:"string" enum:"true"`

	// The storage for the user.
	Storage *UserStorageMetadata `type:"structure"`

	// The surname of the user.
	Surname *string `min:"1" type:"string"`

	// The time zone ID of the user.
	TimeZoneId *string `min:"1" type:"string"`

	// The type of user.
	Type UserType `type:"string" enum:"true"`

	// The login name of the user.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s User) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GivenName != nil {
		v := *s.GivenName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GivenName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Locale) > 0 {
		v := s.Locale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Locale", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ModifiedTimestamp != nil {
		v := *s.ModifiedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModifiedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.OrganizationId != nil {
		v := *s.OrganizationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OrganizationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecycleBinFolderId != nil {
		v := *s.RecycleBinFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecycleBinFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RootFolderId != nil {
		v := *s.RootFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RootFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Storage != nil {
		v := s.Storage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Storage", v, metadata)
	}
	if s.Surname != nil {
		v := *s.Surname

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Surname", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TimeZoneId != nil {
		v := *s.TimeZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the metadata of the user.
type UserMetadata struct {
	_ struct{} `type:"structure"`

	// The email address of the user.
	EmailAddress *string `min:"1" type:"string"`

	// The given name of the user before a rename operation.
	GivenName *string `min:"1" type:"string"`

	// The ID of the user.
	Id *string `min:"1" type:"string"`

	// The surname of the user.
	Surname *string `min:"1" type:"string"`

	// The name of the user.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GivenName != nil {
		v := *s.GivenName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GivenName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Surname != nil {
		v := *s.Surname

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Surname", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the storage for a user.
type UserStorageMetadata struct {
	_ struct{} `type:"structure"`

	// The storage for a user.
	StorageRule *StorageRuleType `type:"structure"`

	// The amount of storage used, in bytes.
	StorageUtilizedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s UserStorageMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserStorageMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.StorageRule != nil {
		v := s.StorageRule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StorageRule", v, metadata)
	}
	if s.StorageUtilizedInBytes != nil {
		v := *s.StorageUtilizedInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageUtilizedInBytes", protocol.Int64Value(v), metadata)
	}
	return nil
}
