// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFleetInput"}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFleetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFleetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Deletes a fleet. Prevents users from accessing previously associated websites.
//
//    // Example sending a request using DeleteFleetRequest.
//    req := client.DeleteFleetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet
func (c *Client) DeleteFleetRequest(input *DeleteFleetInput) DeleteFleetRequest {
	op := &aws.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteFleet",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	req := c.newRequest(op, input, &DeleteFleetOutput{})

	return DeleteFleetRequest{Request: req, Input: input, Copy: c.DeleteFleetRequest}
}

// DeleteFleetRequest is the request type for the
// DeleteFleet API operation.
type DeleteFleetRequest struct {
	*aws.Request
	Input *DeleteFleetInput
	Copy  func(*DeleteFleetInput) DeleteFleetRequest
}

// Send marshals and sends the DeleteFleet API request.
func (r DeleteFleetRequest) Send(ctx context.Context) (*DeleteFleetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFleetResponse{
		DeleteFleetOutput: r.Request.Data.(*DeleteFleetOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFleetResponse is the response type for the
// DeleteFleet API operation.
type DeleteFleetResponse struct {
	*DeleteFleetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFleet request.
func (r *DeleteFleetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
