// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SignOutUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignOutUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignOutUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SignOutUserInput"}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SignOutUserInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SignOutUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignOutUserOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SignOutUserOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opSignOutUser = "SignOutUser"

// SignOutUserRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Signs the user out from all of their devices. The user can sign in again
// if they have valid credentials.
//
//    // Example sending a request using SignOutUserRequest.
//    req := client.SignOutUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser
func (c *Client) SignOutUserRequest(input *SignOutUserInput) SignOutUserRequest {
	op := &aws.Operation{
		Name:       opSignOutUser,
		HTTPMethod: "POST",
		HTTPPath:   "/signOutUser",
	}

	if input == nil {
		input = &SignOutUserInput{}
	}

	req := c.newRequest(op, input, &SignOutUserOutput{})

	return SignOutUserRequest{Request: req, Input: input, Copy: c.SignOutUserRequest}
}

// SignOutUserRequest is the request type for the
// SignOutUser API operation.
type SignOutUserRequest struct {
	*aws.Request
	Input *SignOutUserInput
	Copy  func(*SignOutUserInput) SignOutUserRequest
}

// Send marshals and sends the SignOutUser API request.
func (r SignOutUserRequest) Send(ctx context.Context) (*SignOutUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SignOutUserResponse{
		SignOutUserOutput: r.Request.Data.(*SignOutUserOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SignOutUserResponse is the response type for the
// SignOutUser API operation.
type SignOutUserResponse struct {
	*SignOutUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SignOutUser request.
func (r *SignOutUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
