// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateIdentityProviderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The SAML metadata document provided by the customer’s identity provider.
	// The existing IdentityProviderSamlMetadata is unset if null is passed.
	IdentityProviderSamlMetadata *string `min:"1" type:"string"`

	// The type of identity provider.
	//
	// IdentityProviderType is a required field
	IdentityProviderType IdentityProviderType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateIdentityProviderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentityProviderConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateIdentityProviderConfigurationInput"}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}
	if s.IdentityProviderSamlMetadata != nil && len(*s.IdentityProviderSamlMetadata) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityProviderSamlMetadata", 1))
	}
	if len(s.IdentityProviderType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("IdentityProviderType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateIdentityProviderConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityProviderSamlMetadata != nil {
		v := *s.IdentityProviderSamlMetadata

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityProviderSamlMetadata", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IdentityProviderType) > 0 {
		v := s.IdentityProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type UpdateIdentityProviderConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateIdentityProviderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateIdentityProviderConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateIdentityProviderConfiguration = "UpdateIdentityProviderConfiguration"

// UpdateIdentityProviderConfigurationRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Updates the identity provider configuration for the fleet.
//
//    // Example sending a request using UpdateIdentityProviderConfigurationRequest.
//    req := client.UpdateIdentityProviderConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration
func (c *Client) UpdateIdentityProviderConfigurationRequest(input *UpdateIdentityProviderConfigurationInput) UpdateIdentityProviderConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateIdentityProviderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/updateIdentityProviderConfiguration",
	}

	if input == nil {
		input = &UpdateIdentityProviderConfigurationInput{}
	}

	req := c.newRequest(op, input, &UpdateIdentityProviderConfigurationOutput{})

	return UpdateIdentityProviderConfigurationRequest{Request: req, Input: input, Copy: c.UpdateIdentityProviderConfigurationRequest}
}

// UpdateIdentityProviderConfigurationRequest is the request type for the
// UpdateIdentityProviderConfiguration API operation.
type UpdateIdentityProviderConfigurationRequest struct {
	*aws.Request
	Input *UpdateIdentityProviderConfigurationInput
	Copy  func(*UpdateIdentityProviderConfigurationInput) UpdateIdentityProviderConfigurationRequest
}

// Send marshals and sends the UpdateIdentityProviderConfiguration API request.
func (r UpdateIdentityProviderConfigurationRequest) Send(ctx context.Context) (*UpdateIdentityProviderConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateIdentityProviderConfigurationResponse{
		UpdateIdentityProviderConfigurationOutput: r.Request.Data.(*UpdateIdentityProviderConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateIdentityProviderConfigurationResponse is the response type for the
// UpdateIdentityProviderConfiguration API operation.
type UpdateIdentityProviderConfigurationResponse struct {
	*UpdateIdentityProviderConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateIdentityProviderConfiguration request.
func (r *UpdateIdentityProviderConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
