// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the member (user or group)that owns the mailbox.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier of the member (user or group) for which to delete granted
	// permissions.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The identifier of the organization under which the member (user or group)
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMailboxPermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMailboxPermissionsInput"}

	if s.EntityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("EntityId", 12))
	}

	if s.GranteeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GranteeId"))
	}
	if s.GranteeId != nil && len(*s.GranteeId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("GranteeId", 12))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteMailboxPermissions = "DeleteMailboxPermissions"

// DeleteMailboxPermissionsRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Deletes permissions granted to a member (user or group).
//
//    // Example sending a request using DeleteMailboxPermissionsRequest.
//    req := client.DeleteMailboxPermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions
func (c *Client) DeleteMailboxPermissionsRequest(input *DeleteMailboxPermissionsInput) DeleteMailboxPermissionsRequest {
	op := &aws.Operation{
		Name:       opDeleteMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMailboxPermissionsInput{}
	}

	req := c.newRequest(op, input, &DeleteMailboxPermissionsOutput{})

	return DeleteMailboxPermissionsRequest{Request: req, Input: input, Copy: c.DeleteMailboxPermissionsRequest}
}

// DeleteMailboxPermissionsRequest is the request type for the
// DeleteMailboxPermissions API operation.
type DeleteMailboxPermissionsRequest struct {
	*aws.Request
	Input *DeleteMailboxPermissionsInput
	Copy  func(*DeleteMailboxPermissionsInput) DeleteMailboxPermissionsRequest
}

// Send marshals and sends the DeleteMailboxPermissions API request.
func (r DeleteMailboxPermissionsRequest) Send(ctx context.Context) (*DeleteMailboxPermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMailboxPermissionsResponse{
		DeleteMailboxPermissionsOutput: r.Request.Data.(*DeleteMailboxPermissionsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMailboxPermissionsResponse is the response type for the
// DeleteMailboxPermissions API operation.
type DeleteMailboxPermissionsResponse struct {
	*DeleteMailboxPermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMailboxPermissions request.
func (r *DeleteMailboxPermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
