// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The retention policy description.
	Description *string `type:"string"`

	// The retention policy folder configurations.
	//
	// FolderConfigurations is a required field
	FolderConfigurations []FolderConfiguration `type:"list" required:"true"`

	// The retention policy ID.
	Id *string `min:"1" type:"string"`

	// The retention policy name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRetentionPolicyInput"}

	if s.FolderConfigurations == nil {
		invalidParams.Add(aws.NewErrParamRequired("FolderConfigurations"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}
	if s.FolderConfigurations != nil {
		for i, v := range s.FolderConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FolderConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutRetentionPolicy = "PutRetentionPolicy"

// PutRetentionPolicyRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Puts a retention policy to the specified organization.
//
//    // Example sending a request using PutRetentionPolicyRequest.
//    req := client.PutRetentionPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy
func (c *Client) PutRetentionPolicyRequest(input *PutRetentionPolicyInput) PutRetentionPolicyRequest {
	op := &aws.Operation{
		Name:       opPutRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionPolicyInput{}
	}

	req := c.newRequest(op, input, &PutRetentionPolicyOutput{})

	return PutRetentionPolicyRequest{Request: req, Input: input, Copy: c.PutRetentionPolicyRequest}
}

// PutRetentionPolicyRequest is the request type for the
// PutRetentionPolicy API operation.
type PutRetentionPolicyRequest struct {
	*aws.Request
	Input *PutRetentionPolicyInput
	Copy  func(*PutRetentionPolicyInput) PutRetentionPolicyRequest
}

// Send marshals and sends the PutRetentionPolicy API request.
func (r PutRetentionPolicyRequest) Send(ctx context.Context) (*PutRetentionPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRetentionPolicyResponse{
		PutRetentionPolicyOutput: r.Request.Data.(*PutRetentionPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRetentionPolicyResponse is the response type for the
// PutRetentionPolicy API operation.
type PutRetentionPolicyResponse struct {
	*PutRetentionPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRetentionPolicy request.
func (r *PutRetentionPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
