// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeregisterWorkspaceDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory. If any WorkSpaces are registered to this
	// directory, you must remove them before you deregister the directory, or you
	// will receive an OperationNotSupportedException error.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterWorkspaceDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterWorkspaceDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterWorkspaceDirectoryInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("DirectoryId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterWorkspaceDirectoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterWorkspaceDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterWorkspaceDirectory = "DeregisterWorkspaceDirectory"

// DeregisterWorkspaceDirectoryRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Deregisters the specified directory. This operation is asynchronous and returns
// before the WorkSpace directory is deregistered. If any WorkSpaces are registered
// to this directory, you must remove them before you can deregister the directory.
//
//    // Example sending a request using DeregisterWorkspaceDirectoryRequest.
//    req := client.DeregisterWorkspaceDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory
func (c *Client) DeregisterWorkspaceDirectoryRequest(input *DeregisterWorkspaceDirectoryInput) DeregisterWorkspaceDirectoryRequest {
	op := &aws.Operation{
		Name:       opDeregisterWorkspaceDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterWorkspaceDirectoryInput{}
	}

	req := c.newRequest(op, input, &DeregisterWorkspaceDirectoryOutput{})

	return DeregisterWorkspaceDirectoryRequest{Request: req, Input: input, Copy: c.DeregisterWorkspaceDirectoryRequest}
}

// DeregisterWorkspaceDirectoryRequest is the request type for the
// DeregisterWorkspaceDirectory API operation.
type DeregisterWorkspaceDirectoryRequest struct {
	*aws.Request
	Input *DeregisterWorkspaceDirectoryInput
	Copy  func(*DeregisterWorkspaceDirectoryInput) DeregisterWorkspaceDirectoryRequest
}

// Send marshals and sends the DeregisterWorkspaceDirectory API request.
func (r DeregisterWorkspaceDirectoryRequest) Send(ctx context.Context) (*DeregisterWorkspaceDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterWorkspaceDirectoryResponse{
		DeregisterWorkspaceDirectoryOutput: r.Request.Data.(*DeregisterWorkspaceDirectoryOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterWorkspaceDirectoryResponse is the response type for the
// DeregisterWorkspaceDirectory API operation.
type DeregisterWorkspaceDirectoryResponse struct {
	*DeregisterWorkspaceDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterWorkspaceDirectory request.
func (r *DeregisterWorkspaceDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
