// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyAccountInput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface. Specify an IP address range that is compatible with your
	// network and in CIDR notation (that is, specify the range as an IPv4 CIDR
	// block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It
	// must also be specified as available by the ListAvailableManagementCidrRanges
	// operation.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL.
	DedicatedTenancySupport DedicatedTenancySupportEnum `type:"string" enum:"true"`
}

// String returns the string representation
func (s ModifyAccountInput) String() string {
	return awsutil.Prettify(s)
}

type ModifyAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyAccount = "ModifyAccount"

// ModifyAccountRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Modifies the configuration of Bring Your Own License (BYOL) for the specified
// account.
//
//    // Example sending a request using ModifyAccountRequest.
//    req := client.ModifyAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *Client) ModifyAccountRequest(input *ModifyAccountInput) ModifyAccountRequest {
	op := &aws.Operation{
		Name:       opModifyAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAccountInput{}
	}

	req := c.newRequest(op, input, &ModifyAccountOutput{})

	return ModifyAccountRequest{Request: req, Input: input, Copy: c.ModifyAccountRequest}
}

// ModifyAccountRequest is the request type for the
// ModifyAccount API operation.
type ModifyAccountRequest struct {
	*aws.Request
	Input *ModifyAccountInput
	Copy  func(*ModifyAccountInput) ModifyAccountRequest
}

// Send marshals and sends the ModifyAccount API request.
func (r ModifyAccountRequest) Send(ctx context.Context) (*ModifyAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyAccountResponse{
		ModifyAccountOutput: r.Request.Data.(*ModifyAccountOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyAccountResponse is the response type for the
// ModifyAccount API operation.
type ModifyAccountResponse struct {
	*ModifyAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyAccount request.
func (r *ModifyAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
