// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateSamplingRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule definition.
	//
	// SamplingRule is a required field
	SamplingRule *SamplingRule `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSamplingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSamplingRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSamplingRuleInput"}

	if s.SamplingRule == nil {
		invalidParams.Add(aws.NewErrParamRequired("SamplingRule"))
	}
	if s.SamplingRule != nil {
		if err := s.SamplingRule.Validate(); err != nil {
			invalidParams.AddNested("SamplingRule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSamplingRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SamplingRule != nil {
		v := s.SamplingRule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SamplingRule", v, metadata)
	}
	return nil
}

type CreateSamplingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The saved rule definition and metadata.
	SamplingRuleRecord *SamplingRuleRecord `type:"structure"`
}

// String returns the string representation
func (s CreateSamplingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSamplingRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SamplingRuleRecord != nil {
		v := s.SamplingRuleRecord

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SamplingRuleRecord", v, metadata)
	}
	return nil
}

const opCreateSamplingRule = "CreateSamplingRule"

// CreateSamplingRuleRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Creates a rule to control sampling behavior for instrumented applications.
// Services retrieve rules with GetSamplingRules, and evaluate each rule in
// ascending order of priority for each request. If a rule matches, the service
// records a trace, borrowing it from the reservoir size. After 10 seconds,
// the service reports back to X-Ray with GetSamplingTargets to get updated
// versions of each in-use rule. The updated rule contains a trace quota that
// the service can use instead of borrowing from the reservoir.
//
//    // Example sending a request using CreateSamplingRuleRequest.
//    req := client.CreateSamplingRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateSamplingRule
func (c *Client) CreateSamplingRuleRequest(input *CreateSamplingRuleInput) CreateSamplingRuleRequest {
	op := &aws.Operation{
		Name:       opCreateSamplingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateSamplingRule",
	}

	if input == nil {
		input = &CreateSamplingRuleInput{}
	}

	req := c.newRequest(op, input, &CreateSamplingRuleOutput{})

	return CreateSamplingRuleRequest{Request: req, Input: input, Copy: c.CreateSamplingRuleRequest}
}

// CreateSamplingRuleRequest is the request type for the
// CreateSamplingRule API operation.
type CreateSamplingRuleRequest struct {
	*aws.Request
	Input *CreateSamplingRuleInput
	Copy  func(*CreateSamplingRuleInput) CreateSamplingRuleRequest
}

// Send marshals and sends the CreateSamplingRule API request.
func (r CreateSamplingRuleRequest) Send(ctx context.Context) (*CreateSamplingRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSamplingRuleResponse{
		CreateSamplingRuleOutput: r.Request.Data.(*CreateSamplingRuleOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSamplingRuleResponse is the response type for the
// CreateSamplingRule API operation.
type CreateSamplingRuleResponse struct {
	*CreateSamplingRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSamplingRule request.
func (r *CreateSamplingRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
