// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetSamplingStatisticSummariesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetSamplingStatisticSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSamplingStatisticSummariesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetSamplingStatisticSummariesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Information about the number of requests instrumented for each sampling rule.
	SamplingStatisticSummaries []SamplingStatisticSummary `type:"list"`
}

// String returns the string representation
func (s GetSamplingStatisticSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSamplingStatisticSummariesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SamplingStatisticSummaries != nil {
		v := s.SamplingStatisticSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SamplingStatisticSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetSamplingStatisticSummaries = "GetSamplingStatisticSummaries"

// GetSamplingStatisticSummariesRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Retrieves information about recent sampling results for all sampling rules.
//
//    // Example sending a request using GetSamplingStatisticSummariesRequest.
//    req := client.GetSamplingStatisticSummariesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries
func (c *Client) GetSamplingStatisticSummariesRequest(input *GetSamplingStatisticSummariesInput) GetSamplingStatisticSummariesRequest {
	op := &aws.Operation{
		Name:       opGetSamplingStatisticSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/SamplingStatisticSummaries",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSamplingStatisticSummariesInput{}
	}

	req := c.newRequest(op, input, &GetSamplingStatisticSummariesOutput{})

	return GetSamplingStatisticSummariesRequest{Request: req, Input: input, Copy: c.GetSamplingStatisticSummariesRequest}
}

// GetSamplingStatisticSummariesRequest is the request type for the
// GetSamplingStatisticSummaries API operation.
type GetSamplingStatisticSummariesRequest struct {
	*aws.Request
	Input *GetSamplingStatisticSummariesInput
	Copy  func(*GetSamplingStatisticSummariesInput) GetSamplingStatisticSummariesRequest
}

// Send marshals and sends the GetSamplingStatisticSummaries API request.
func (r GetSamplingStatisticSummariesRequest) Send(ctx context.Context) (*GetSamplingStatisticSummariesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSamplingStatisticSummariesResponse{
		GetSamplingStatisticSummariesOutput: r.Request.Data.(*GetSamplingStatisticSummariesOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetSamplingStatisticSummariesRequestPaginator returns a paginator for GetSamplingStatisticSummaries.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetSamplingStatisticSummariesRequest(input)
//   p := xray.NewGetSamplingStatisticSummariesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetSamplingStatisticSummariesPaginator(req GetSamplingStatisticSummariesRequest) GetSamplingStatisticSummariesPaginator {
	return GetSamplingStatisticSummariesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetSamplingStatisticSummariesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetSamplingStatisticSummariesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetSamplingStatisticSummariesPaginator struct {
	aws.Pager
}

func (p *GetSamplingStatisticSummariesPaginator) CurrentPage() *GetSamplingStatisticSummariesOutput {
	return p.Pager.CurrentPage().(*GetSamplingStatisticSummariesOutput)
}

// GetSamplingStatisticSummariesResponse is the response type for the
// GetSamplingStatisticSummaries API operation.
type GetSamplingStatisticSummariesResponse struct {
	*GetSamplingStatisticSummariesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSamplingStatisticSummaries request.
func (r *GetSamplingStatisticSummariesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
