// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetTimeSeriesServiceStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time frame for which to aggregate statistics.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// A filter expression defining entities that will be aggregated for statistics.
	// Supports ID, service, and edge functions. If no selector expression is specified,
	// edge statistics are returned.
	EntitySelectorExpression *string `min:"1" type:"string"`

	// The ARN of the group for which to pull statistics from.
	GroupARN *string `min:"1" type:"string"`

	// The case-sensitive name of the group for which to pull statistics from.
	GroupName *string `min:"1" type:"string"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Aggregation period in seconds.
	Period *int64 `type:"integer"`

	// The start of the time frame for which to aggregate statistics.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetTimeSeriesServiceStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTimeSeriesServiceStatisticsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTimeSeriesServiceStatisticsInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if s.EntitySelectorExpression != nil && len(*s.EntitySelectorExpression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EntitySelectorExpression", 1))
	}
	if s.GroupARN != nil && len(*s.GroupARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupARN", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetTimeSeriesServiceStatisticsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EntitySelectorExpression != nil {
		v := *s.EntitySelectorExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EntitySelectorExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupARN != nil {
		v := *s.GroupARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Period != nil {
		v := *s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Period", protocol.Int64Value(v), metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

type GetTimeSeriesServiceStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether or not a group's filter expression has been consistent,
	// or if a returned aggregation may show statistics from an older version of
	// the group's filter expression.
	ContainsOldGroupVersions *bool `type:"boolean"`

	// Pagination token.
	NextToken *string `type:"string"`

	// The collection of statistics.
	TimeSeriesServiceStatistics []TimeSeriesServiceStatistics `type:"list"`
}

// String returns the string representation
func (s GetTimeSeriesServiceStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetTimeSeriesServiceStatisticsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainsOldGroupVersions != nil {
		v := *s.ContainsOldGroupVersions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContainsOldGroupVersions", protocol.BoolValue(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TimeSeriesServiceStatistics != nil {
		v := s.TimeSeriesServiceStatistics

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TimeSeriesServiceStatistics", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetTimeSeriesServiceStatistics = "GetTimeSeriesServiceStatistics"

// GetTimeSeriesServiceStatisticsRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Get an aggregation of service statistics defined by a specific time range.
//
//    // Example sending a request using GetTimeSeriesServiceStatisticsRequest.
//    req := client.GetTimeSeriesServiceStatisticsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics
func (c *Client) GetTimeSeriesServiceStatisticsRequest(input *GetTimeSeriesServiceStatisticsInput) GetTimeSeriesServiceStatisticsRequest {
	op := &aws.Operation{
		Name:       opGetTimeSeriesServiceStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/TimeSeriesServiceStatistics",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTimeSeriesServiceStatisticsInput{}
	}

	req := c.newRequest(op, input, &GetTimeSeriesServiceStatisticsOutput{})

	return GetTimeSeriesServiceStatisticsRequest{Request: req, Input: input, Copy: c.GetTimeSeriesServiceStatisticsRequest}
}

// GetTimeSeriesServiceStatisticsRequest is the request type for the
// GetTimeSeriesServiceStatistics API operation.
type GetTimeSeriesServiceStatisticsRequest struct {
	*aws.Request
	Input *GetTimeSeriesServiceStatisticsInput
	Copy  func(*GetTimeSeriesServiceStatisticsInput) GetTimeSeriesServiceStatisticsRequest
}

// Send marshals and sends the GetTimeSeriesServiceStatistics API request.
func (r GetTimeSeriesServiceStatisticsRequest) Send(ctx context.Context) (*GetTimeSeriesServiceStatisticsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTimeSeriesServiceStatisticsResponse{
		GetTimeSeriesServiceStatisticsOutput: r.Request.Data.(*GetTimeSeriesServiceStatisticsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTimeSeriesServiceStatisticsRequestPaginator returns a paginator for GetTimeSeriesServiceStatistics.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTimeSeriesServiceStatisticsRequest(input)
//   p := xray.NewGetTimeSeriesServiceStatisticsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTimeSeriesServiceStatisticsPaginator(req GetTimeSeriesServiceStatisticsRequest) GetTimeSeriesServiceStatisticsPaginator {
	return GetTimeSeriesServiceStatisticsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTimeSeriesServiceStatisticsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTimeSeriesServiceStatisticsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTimeSeriesServiceStatisticsPaginator struct {
	aws.Pager
}

func (p *GetTimeSeriesServiceStatisticsPaginator) CurrentPage() *GetTimeSeriesServiceStatisticsOutput {
	return p.Pager.CurrentPage().(*GetTimeSeriesServiceStatisticsOutput)
}

// GetTimeSeriesServiceStatisticsResponse is the response type for the
// GetTimeSeriesServiceStatistics API operation.
type GetTimeSeriesServiceStatisticsResponse struct {
	*GetTimeSeriesServiceStatisticsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTimeSeriesServiceStatistics request.
func (r *GetTimeSeriesServiceStatisticsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
