// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutTraceSegmentsInput struct {
	_ struct{} `type:"structure"`

	// A string containing a JSON document defining one or more segments or subsegments.
	//
	// TraceSegmentDocuments is a required field
	TraceSegmentDocuments []string `type:"list" required:"true"`
}

// String returns the string representation
func (s PutTraceSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTraceSegmentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutTraceSegmentsInput"}

	if s.TraceSegmentDocuments == nil {
		invalidParams.Add(aws.NewErrParamRequired("TraceSegmentDocuments"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutTraceSegmentsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TraceSegmentDocuments != nil {
		v := s.TraceSegmentDocuments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TraceSegmentDocuments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type PutTraceSegmentsOutput struct {
	_ struct{} `type:"structure"`

	// Segments that failed processing.
	UnprocessedTraceSegments []UnprocessedTraceSegment `type:"list"`
}

// String returns the string representation
func (s PutTraceSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutTraceSegmentsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnprocessedTraceSegments != nil {
		v := s.UnprocessedTraceSegments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UnprocessedTraceSegments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opPutTraceSegments = "PutTraceSegments"

// PutTraceSegmentsRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Uploads segment documents to AWS X-Ray. The X-Ray SDK (https://docs.aws.amazon.com/xray/index.html)
// generates segment documents and sends them to the X-Ray daemon, which uploads
// them in batches. A segment document can be a completed segment, an in-progress
// segment, or an array of subsegments.
//
// Segments must include the following fields. For the full segment document
// schema, see AWS X-Ray Segment Documents (https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
// in the AWS X-Ray Developer Guide.
//
// Required Segment Document Fields
//
//    * name - The name of the service that handled the request.
//
//    * id - A 64-bit identifier for the segment, unique among segments in the
//    same trace, in 16 hexadecimal digits.
//
//    * trace_id - A unique identifier that connects all segments and subsegments
//    originating from a single client request.
//
//    * start_time - Time the segment or subsegment was created, in floating
//    point seconds in epoch time, accurate to milliseconds. For example, 1480615200.010
//    or 1.480615200010E9.
//
//    * end_time - Time the segment or subsegment was closed. For example, 1480615200.090
//    or 1.480615200090E9. Specify either an end_time or in_progress.
//
//    * in_progress - Set to true instead of specifying an end_time to record
//    that a segment has been started, but is not complete. Send an in progress
//    segment when your application receives a request that will take a long
//    time to serve, to trace the fact that the request was received. When the
//    response is sent, send the complete segment to overwrite the in-progress
//    segment.
//
// A trace_id consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979.
// This includes:
//
// Trace ID Format
//
//    * The version number, i.e. 1.
//
//    * The time of the original request, in Unix epoch time, in 8 hexadecimal
//    digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is 1480615200
//    seconds, or 58406520 in hexadecimal.
//
//    * A 96-bit identifier for the trace, globally unique, in 24 hexadecimal
//    digits.
//
//    // Example sending a request using PutTraceSegmentsRequest.
//    req := client.PutTraceSegmentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments
func (c *Client) PutTraceSegmentsRequest(input *PutTraceSegmentsInput) PutTraceSegmentsRequest {
	op := &aws.Operation{
		Name:       opPutTraceSegments,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceSegments",
	}

	if input == nil {
		input = &PutTraceSegmentsInput{}
	}

	req := c.newRequest(op, input, &PutTraceSegmentsOutput{})

	return PutTraceSegmentsRequest{Request: req, Input: input, Copy: c.PutTraceSegmentsRequest}
}

// PutTraceSegmentsRequest is the request type for the
// PutTraceSegments API operation.
type PutTraceSegmentsRequest struct {
	*aws.Request
	Input *PutTraceSegmentsInput
	Copy  func(*PutTraceSegmentsInput) PutTraceSegmentsRequest
}

// Send marshals and sends the PutTraceSegments API request.
func (r PutTraceSegmentsRequest) Send(ctx context.Context) (*PutTraceSegmentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutTraceSegmentsResponse{
		PutTraceSegmentsOutput: r.Request.Data.(*PutTraceSegmentsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutTraceSegmentsResponse is the response type for the
// PutTraceSegments API operation.
type PutTraceSegmentsResponse struct {
	*PutTraceSegmentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutTraceSegments request.
func (r *PutTraceSegmentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
