// GENERATED FILE - DO NOT EDIT.
// Generated by gen_overlay_widgets.py using data from overlay_widgets.json.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Overlay_autogen.cpp:
//   Autogenerated overlay widget declarations.

#include "libANGLE/Overlay.h"
#include "libANGLE/OverlayWidgets.h"
#include "libANGLE/Overlay_font_autogen.h"
#include "libANGLE/renderer/driver_utils.h"

namespace gl
{
using namespace overlay;

namespace
{
int GetFontSize(int fontSize, bool largeFont)
{
    if (largeFont && fontSize > 0)
    {
        return fontSize - 1;
    }
    return fontSize;
}
}  // anonymous namespace

void Overlay::initOverlayWidgets()
{
    const bool kLargeFont = rx::IsAndroid();

    {
        PerSecond *widget = new PerSecond;
        {
            const int32_t fontSize = GetFontSize(kFontMipLarge, kLargeFont);
            const int32_t offsetX  = 10;
            const int32_t offsetY  = 10;
            const int32_t width    = 12 * (kFontGlyphWidth >> fontSize);
            const int32_t height   = (kFontGlyphHeight >> fontSize);

            widget->type          = WidgetType::PerSecond;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 0.4980392156862745f;
            widget->color[1]      = 0.7490196078431373f;
            widget->color[2]      = 1.0f;
            widget->color[3]      = 1.0f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::FPS].reset(widget);
    }

    {
        Text *widget = new Text;
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX  = 10;
            const int32_t offsetY  = -10;
            const int32_t width    = 150 * (kFontGlyphWidth >> fontSize);
            const int32_t height   = (kFontGlyphHeight >> fontSize);

            widget->type          = WidgetType::Text;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY - height;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.0f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 1.0f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanLastValidationMessage].reset(widget);
    }

    {
        Count *widget = new Count;
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX  = 10;
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanLastValidationMessage]->coords[1];
            const int32_t width  = 25 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->type          = WidgetType::Count;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY - height;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.0f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 1.0f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanValidationMessageCount].reset(widget);
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = 10;
            const int32_t offsetY  = 100;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 0.29411764705882354f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanRenderPassCount].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanRenderPassCount]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanRenderPassCount]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = offsetX + width;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.29411764705882354f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.0f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(100);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = -50;
            const int32_t offsetY  = 100;
            const int32_t width    = 6 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX - width;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.29411764705882354f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanRenderPassBufferCount].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanRenderPassBufferCount]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanRenderPassBufferCount]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 1.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningHistogram *widget = new RunningHistogram(50);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = -50;
            const int32_t offsetY  = 100;
            const int32_t width    = 6 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningHistogram;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX - width;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.29411764705882354f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanSecondaryCommandBufferPoolWaste].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanSecondaryCommandBufferPoolWaste]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanSecondaryCommandBufferPoolWaste]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 1.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = 10;
            const int32_t offsetY  = 220;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 0.29411764705882354f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanWriteDescriptorSetCount].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanWriteDescriptorSetCount]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanWriteDescriptorSetCount]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = offsetX + width;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.29411764705882354f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.0f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = 0;
            const int32_t offsetY  = 250;
            const int32_t width    = 6 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.0f;
            widget->color[2]      = 0.29411764705882354f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanDescriptorSetAllocations].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanDescriptorSetAllocations]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanDescriptorSetAllocations]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = offsetX + width;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 1.0f;
            widget->description.color[1]      = 0.0f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = -50;
            const int32_t offsetY  = 360;
            const int32_t width    = 6 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX - width;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.0f;
            widget->color[2]      = 0.29411764705882354f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanShaderResourceDSHitRate].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanShaderResourceDSHitRate]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanShaderResourceDSHitRate]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 1.0f;
            widget->description.color[1]      = 0.0f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(120);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = -50;
            const int32_t offsetY  = -50;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX - width;
            widget->coords[1]     = offsetY - height;
            widget->coords[2]     = offsetX;
            widget->coords[3]     = offsetY;
            widget->color[0]      = 0.0f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.29411764705882354f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanDynamicBufferAllocations].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanDynamicBufferAllocations]->coords[2];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanDynamicBufferAllocations]->coords[1];
            const int32_t width  = 40 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX - width;
            widget->description.coords[1]     = offsetY - height;
            widget->description.coords[2]     = offsetX;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = 0;
            const int32_t offsetY  = 450;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 0.0f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.7254901960784313f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanDescriptorCacheSize].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanDescriptorCacheSize]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanDescriptorCacheSize]->coords[1];
            const int32_t width  = 90 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = offsetX + width;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = 0;
            const int32_t offsetY  = 450;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 0.0f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 0.29411764705882354f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanTextureDescriptorCacheSize].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanTextureDescriptorCacheSize]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanTextureDescriptorCacheSize]->coords[1];
            const int32_t width  = 90 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = offsetX + width;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = 0;
            const int32_t offsetY  = 450;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 0.0f;
            widget->color[1]      = 0.7843137254901961f;
            widget->color[2]      = 1.0f;
            widget->color[3]      = 0.7843137254901961f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanUniformDescriptorCacheSize].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanUniformDescriptorCacheSize]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanUniformDescriptorCacheSize]->coords[1];
            const int32_t width  = 90 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = offsetX + width;
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        Count *widget = new Count;
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX  = 10;
            const int32_t offsetY  = 100;
            const int32_t width    = 30 * (kFontGlyphWidth >> fontSize);
            const int32_t height   = (kFontGlyphHeight >> fontSize);

            widget->type          = WidgetType::Count;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX + width;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 1.0f;
            widget->color[2]      = 1.0f;
            widget->color[3]      = 1.0f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanDescriptorCacheKeySize].reset(widget);
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = -50;
            const int32_t offsetY  = 50;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX - width;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = offsetX;
            widget->coords[3]     = offsetY + height;
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.0f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 0.39215686274509803f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanAttemptedSubmissions].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanAttemptedSubmissions]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanAttemptedSubmissions]->coords[1];
            const int32_t width  = 45 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = std::max(offsetY - height, 1);
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.7843137254901961f;
            widget->description.color[1]      = 0.0f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanAttemptedSubmissions]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanAttemptedSubmissions]->coords[1];
            const int32_t width  = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height = 100;

            widget->type      = WidgetType::RunningGraph;
            widget->fontSize  = fontSize;
            widget->coords[0] = offsetX;
            widget->coords[1] = offsetY;
            widget->coords[2] = std::min(offsetX + width, -1);
            widget->coords[3] = offsetY + height;
            widget->color[0]  = 0.0f;
            widget->color[1]  = 1.0f;
            widget->color[2]  = 0.0f;
            widget->color[3]  = 0.7843137254901961f;
            widget->matchToWidget =
                mState.mOverlayWidgets[WidgetId::VulkanAttemptedSubmissions].get();
        }
        mState.mOverlayWidgets[WidgetId::VulkanActualSubmissions].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanActualSubmissions]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanActualSubmissions]->coords[3];
            const int32_t width  = 45 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = offsetY;
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY + height;
            widget->description.color[0]      = 0.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX  = -50;
            const int32_t offsetY  = -50;
            const int32_t width    = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height   = 100;

            widget->type          = WidgetType::RunningGraph;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX - width;
            widget->coords[1]     = offsetY - height;
            widget->coords[2]     = offsetX;
            widget->coords[3]     = offsetY;
            widget->color[0]      = 0.0f;
            widget->color[1]      = 1.0f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 0.39215686274509803f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups]->coords[1];
            const int32_t width  = 45 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = offsetY - height;
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.0f;
            widget->description.color[1]      = 0.7843137254901961f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        RunningGraph *widget = new RunningGraph(60);
        {
            const int32_t fontSize = GetFontSize(0, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups]->coords[1];
            const int32_t width  = 5 * static_cast<uint32_t>(widget->runningValues.size());
            const int32_t height = 100;

            widget->type      = WidgetType::RunningGraph;
            widget->fontSize  = fontSize;
            widget->coords[0] = offsetX;
            widget->coords[1] = offsetY;
            widget->coords[2] = std::min(offsetX + width, -1);
            widget->coords[3] = std::min(offsetY + height, -1);
            widget->color[0]  = 1.0f;
            widget->color[1]  = 0.0f;
            widget->color[2]  = 0.0f;
            widget->color[3]  = 0.7843137254901961f;
            widget->matchToWidget =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups].get();
        }
        mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheMisses].reset(widget);
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX  = mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups]
                                        ->getDescriptionWidget()
                                        ->coords[0];
            const int32_t offsetY = mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheLookups]
                                        ->getDescriptionWidget()
                                        ->coords[1];
            const int32_t width  = 45 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->description.type          = WidgetType::Text;
            widget->description.fontSize      = fontSize;
            widget->description.coords[0]     = offsetX;
            widget->description.coords[1]     = offsetY - height;
            widget->description.coords[2]     = std::min(offsetX + width, -1);
            widget->description.coords[3]     = offsetY;
            widget->description.color[0]      = 0.7843137254901961f;
            widget->description.color[1]      = 0.0f;
            widget->description.color[2]      = 0.29411764705882354f;
            widget->description.color[3]      = 1.0f;
            widget->description.matchToWidget = nullptr;
        }
    }

    {
        Count *widget = new Count;
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheMisses]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanPipelineCacheMisses]->coords[3];
            const int32_t width  = 45 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->type          = WidgetType::Count;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = std::min(offsetX + width, -1);
            widget->coords[3]     = std::min(offsetY + height, -1);
            widget->color[0]      = 1.0f;
            widget->color[1]      = 0.0f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 1.0f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanTotalPipelineCacheMissTimeMs].reset(widget);
    }

    {
        Count *widget = new Count;
        {
            const int32_t fontSize = GetFontSize(kFontMipSmall, kLargeFont);
            const int32_t offsetX =
                mState.mOverlayWidgets[WidgetId::VulkanTotalPipelineCacheMissTimeMs]->coords[0];
            const int32_t offsetY =
                mState.mOverlayWidgets[WidgetId::VulkanTotalPipelineCacheMissTimeMs]->coords[3];
            const int32_t width  = 45 * (kFontGlyphWidth >> fontSize);
            const int32_t height = (kFontGlyphHeight >> fontSize);

            widget->type          = WidgetType::Count;
            widget->fontSize      = fontSize;
            widget->coords[0]     = offsetX;
            widget->coords[1]     = offsetY;
            widget->coords[2]     = std::min(offsetX + width, -1);
            widget->coords[3]     = std::min(offsetY + height, -1);
            widget->color[0]      = 0.0f;
            widget->color[1]      = 1.0f;
            widget->color[2]      = 0.0f;
            widget->color[3]      = 1.0f;
            widget->matchToWidget = nullptr;
        }
        mState.mOverlayWidgets[WidgetId::VulkanTotalPipelineCacheHitTimeMs].reset(widget);
    }
}

}  // namespace gl
