/*  keynames.c: (c) 2002 sibn

    This file is part of GWiz.

    GWiz is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GWiz is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GWiz; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>

char *KeyToChar (int key)
{
    char *keys[] = {
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	"BackSpace",
	"Tab",
	NULL, 
	
	NULL, 
	"Clear",
	"Enter/Return",
	NULL, NULL, NULL, NULL, NULL, 
	"Pause",
	NULL, 
	
	NULL, NULL, NULL, NULL, NULL, NULL, 
	"Escape",
	NULL, NULL, NULL, 
	
	NULL,
	"Space",
	"!",
	"\"",
	"#",
	"$",
	NULL, 
	"&",
	"\'",
	"(",
	
	")",
	"*",
	"+",
	",",
	"-",
	".",
	"/",
	"/",
	"0",
	"1",
	"2",  /* *** 50 *** */
	
	"3",
	"4",
	"5",
	"6",
	"7",
	"8",
	"9",
	":",
	";",
	"|",
	
	"=",
	">",
	"?",
	"@",
	NULL, NULL, NULL, NULL, NULL, NULL, 
	
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	
	"[",
	"\\",
	"]",
	"^",
	"_",
	"`",
	"a",
	"b",
	"c",
	"d",  /* *** 100 *** */
	
	"e",
	"f",
	"g",
	"h", 
	"i",
	"j",
	"k",
	"l",
	"m",
	"n",
	
	"o",
	"p",
	"q",
	"r",
	"s",
	"t",
	"u",
	"v",
	"w",
	"x",
	
	"y",
	"z",
	
	NULL, NULL, NULL, NULL, 
	"Delete",
	NULL, NULL, NULL, 
	
	/* "International Keys with no "name" */
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
	NULL, NULL, NULL, NULL, NULL,
	/* End international bloc.  Bloc ends with 255 */
	
	"Num 0",
	"Num 1",
	"Num 2",
	"Num 3",
	"Num 4",
	
	"Num 5",
	"Num 6",
	"Num 7",
	"Num 8",
	"Num 9",
	"Num .",
	"Num /",
	"Num *",
	"Num -",
	"Num +",
	
	"Num Enter",
	"Num =",
	"Up",
	"Down",
	"Right",
	"Left",
	"Insert",
	"Home",
	"End",
	"PageUp",
	
	"PageDown",
	"F1",
	"F2",
	"F3",
	"F4",
	"F5",
	"F6",
	"F7",
	"F8",
	"F9",
	
	"F10",
	"F11",
	"F12",
	"F13",
	"F14",
	"F15",
	NULL, NULL, NULL, 
	"NumLock",  /* *** 300 *** */
	
	"CapsLock",
	"ScrollLock",
	"R Shift",
	"L Shift",
	"R Ctrl",
	"L Ctrl",
	"R Alt",
	"L Alt",
	"R Meta",
	"L Meta",
	
	"L Super",
	"R Super",
	"Mode",
	"Compose",
	"Help",
	"Print",
	"SysRq",
	"Break",
	"Menu",
	"Power",
	
	"Euro",
	"Undo"
    };
    return (keys[key]);
}
