package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplicationState enumerates the values for application state.
type ApplicationState string

const (
	// ACCEPTED ...
	ACCEPTED ApplicationState = "ACCEPTED"
	// FAILED ...
	FAILED ApplicationState = "FAILED"
	// FINISHED ...
	FINISHED ApplicationState = "FINISHED"
	// FINISHING ...
	FINISHING ApplicationState = "FINISHING"
	// KILLED ...
	KILLED ApplicationState = "KILLED"
	// NEW ...
	NEW ApplicationState = "NEW"
	// NEWSAVING ...
	NEWSAVING ApplicationState = "NEW_SAVING"
	// RUNNING ...
	RUNNING ApplicationState = "RUNNING"
	// SUBMITTED ...
	SUBMITTED ApplicationState = "SUBMITTED"
)

// PossibleApplicationStateValues returns an array of possible values for the ApplicationState const type.
func PossibleApplicationStateValues() []ApplicationState {
	return []ApplicationState{ACCEPTED, FAILED, FINISHED, FINISHING, KILLED, NEW, NEWSAVING, RUNNING, SUBMITTED}
}

// SessionJobKind enumerates the values for session job kind.
type SessionJobKind string

const (
	// Pyspark ...
	Pyspark SessionJobKind = "pyspark"
	// Spark ...
	Spark SessionJobKind = "spark"
	// Sparkr ...
	Sparkr SessionJobKind = "sparkr"
	// SQL ...
	SQL SessionJobKind = "sql"
)

// PossibleSessionJobKindValues returns an array of possible values for the SessionJobKind const type.
func PossibleSessionJobKindValues() []SessionJobKind {
	return []SessionJobKind{Pyspark, Spark, Sparkr, SQL}
}
