package hybridnetwork

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VirtualNetworkFunctionVendorSkusClient is the client for the VirtualNetworkFunctionVendorSkus methods of the
// Hybridnetwork service.
type VirtualNetworkFunctionVendorSkusClient struct {
	BaseClient
}

// NewVirtualNetworkFunctionVendorSkusClient creates an instance of the VirtualNetworkFunctionVendorSkusClient client.
func NewVirtualNetworkFunctionVendorSkusClient(subscriptionID string) VirtualNetworkFunctionVendorSkusClient {
	return NewVirtualNetworkFunctionVendorSkusClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVirtualNetworkFunctionVendorSkusClientWithBaseURI creates an instance of the
// VirtualNetworkFunctionVendorSkusClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVirtualNetworkFunctionVendorSkusClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkFunctionVendorSkusClient {
	return VirtualNetworkFunctionVendorSkusClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List gets information about hybrid network virtual network function vendor sku details
// Parameters:
// vendorName - the name of the hybrid network virtual network function vendor.
// vendorSkuName - the name of the hybrid network virtual network function sku.
func (client VirtualNetworkFunctionVendorSkusClient) List(ctx context.Context, vendorName string, vendorSkuName string) (result VirtualNetworkFunctionSkuDetailsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorSkusClient.List")
		defer func() {
			sc := -1
			if result.vnfsd.Response.Response != nil {
				sc = result.vnfsd.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, vendorName, vendorSkuName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vnfsd.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "List", resp, "Failure sending request")
		return
	}

	result.vnfsd, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "List", resp, "Failure responding to request")
	}
	if result.vnfsd.hasNextLink() && result.vnfsd.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListPreparer prepares the List request.
func (client VirtualNetworkFunctionVendorSkusClient) ListPreparer(ctx context.Context, vendorName string, vendorSkuName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"vendorName":     autorest.Encode("path", vendorName),
		"vendorSkuName":  autorest.Encode("path", vendorSkuName),
	}

	const APIVersion = "2020-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/virtualNetworkFunctionVendors/{vendorName}/vendorSkus/{vendorSkuName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualNetworkFunctionVendorSkusClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VirtualNetworkFunctionVendorSkusClient) ListResponder(resp *http.Response) (result VirtualNetworkFunctionSkuDetails, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VirtualNetworkFunctionVendorSkusClient) listNextResults(ctx context.Context, lastResults VirtualNetworkFunctionSkuDetails) (result VirtualNetworkFunctionSkuDetails, err error) {
	req, err := lastResults.virtualNetworkFunctionSkuDetailsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualNetworkFunctionVendorSkusClient) ListComplete(ctx context.Context, vendorName string, vendorSkuName string) (result VirtualNetworkFunctionSkuDetailsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorSkusClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, vendorName, vendorSkuName)
	return
}

// ListByVendor list all virtual network function vendor sku details in a vendor
// Parameters:
// vendorName - the name of the hybrid network virtual network function vendor.
func (client VirtualNetworkFunctionVendorSkusClient) ListByVendor(ctx context.Context, vendorName string) (result VirtualNetworkFunctionSkuListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorSkusClient.ListByVendor")
		defer func() {
			sc := -1
			if result.vnfslr.Response.Response != nil {
				sc = result.vnfslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByVendorNextResults
	req, err := client.ListByVendorPreparer(ctx, vendorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "ListByVendor", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByVendorSender(req)
	if err != nil {
		result.vnfslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "ListByVendor", resp, "Failure sending request")
		return
	}

	result.vnfslr, err = client.ListByVendorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "ListByVendor", resp, "Failure responding to request")
	}
	if result.vnfslr.hasNextLink() && result.vnfslr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByVendorPreparer prepares the ListByVendor request.
func (client VirtualNetworkFunctionVendorSkusClient) ListByVendorPreparer(ctx context.Context, vendorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"vendorName":     autorest.Encode("path", vendorName),
	}

	const APIVersion = "2020-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/virtualNetworkFunctionVendors/{vendorName}/vendorSkus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByVendorSender sends the ListByVendor request. The method will close the
// http.Response Body if it receives an error.
func (client VirtualNetworkFunctionVendorSkusClient) ListByVendorSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByVendorResponder handles the response to the ListByVendor request. The method always
// closes the http.Response Body.
func (client VirtualNetworkFunctionVendorSkusClient) ListByVendorResponder(resp *http.Response) (result VirtualNetworkFunctionSkuListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByVendorNextResults retrieves the next set of results, if any.
func (client VirtualNetworkFunctionVendorSkusClient) listByVendorNextResults(ctx context.Context, lastResults VirtualNetworkFunctionSkuListResult) (result VirtualNetworkFunctionSkuListResult, err error) {
	req, err := lastResults.virtualNetworkFunctionSkuListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "listByVendorNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByVendorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "listByVendorNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByVendorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionVendorSkusClient", "listByVendorNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByVendorComplete enumerates all values, automatically crossing page boundaries as required.
func (client VirtualNetworkFunctionVendorSkusClient) ListByVendorComplete(ctx context.Context, vendorName string) (result VirtualNetworkFunctionSkuListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorSkusClient.ListByVendor")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByVendor(ctx, vendorName)
	return
}
