package personalizer

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"io"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/personalizer/v1.0/personalizer"

// ContainerStatus ...
type ContainerStatus struct {
	Service          *string `json:"service,omitempty"`
	APIStatus        *string `json:"apiStatus,omitempty"`
	APIStatusMessage *string `json:"apiStatusMessage,omitempty"`
}

// DateRange ...
type DateRange struct {
	// From - READ-ONLY
	From *date.Time `json:"from,omitempty"`
	// To - READ-ONLY
	To *date.Time `json:"to,omitempty"`
}

// Error the error object.
type Error struct {
	// Code - High level error code. Possible values include: 'BadRequest', 'ResourceNotFound', 'InternalServerError', 'InvalidServiceConfiguration', 'InvalidPolicyConfiguration', 'InvalidPolicyContract', 'InvalidEvaluationContract', 'InvalidRewardRequest', 'InvalidEventIDToActivate', 'InvalidRankRequest', 'InvalidExportLogsRequest', 'InvalidContainer', 'FrontEndNotFound', 'EvaluationNotFound', 'LogsPropertiesNotFound', 'RankNullResponse', 'UpdateConfigurationFailed', 'ModelResetFailed'
	Code ErrorCode `json:"code,omitempty"`
	// Message - A message explaining the error reported by the service.
	Message *string `json:"message,omitempty"`
	// Target - Error source element.
	Target *string `json:"target,omitempty"`
	// Details - An array of details about specific errors that led to this reported error.
	Details *[]Error `json:"details,omitempty"`
	// InnerError - Finer error details.
	InnerError *InternalError `json:"innerError,omitempty"`
}

// ErrorResponse used to return an error to the client
type ErrorResponse struct {
	// Error - The error object.
	Error *Error `json:"error,omitempty"`
}

// Evaluation ...
type Evaluation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// StartTime - READ-ONLY
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY
	EndTime *date.Time `json:"endTime,omitempty"`
	// JobID - READ-ONLY
	JobID *string `json:"jobId,omitempty"`
	// Status - READ-ONLY; Possible values include: 'Completed', 'Pending', 'Failed', 'NotSubmitted'
	Status            EvaluationJobStatus `json:"status,omitempty"`
	PolicyResults     *[]PolicyResult     `json:"policyResults,omitempty"`
	FeatureImportance *[][]string         `json:"featureImportance,omitempty"`
}

// MarshalJSON is the custom marshaler for Evaluation.
func (e Evaluation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.PolicyResults != nil {
		objectMap["policyResults"] = e.PolicyResults
	}
	if e.FeatureImportance != nil {
		objectMap["featureImportance"] = e.FeatureImportance
	}
	return json.Marshal(objectMap)
}

// EvaluationContract a counterfactual evaluation.
type EvaluationContract struct {
	// EnableOfflineExperimentation - True if the evaluation should explore for a more optimal Learning settings.
	EnableOfflineExperimentation *bool `json:"enableOfflineExperimentation,omitempty"`
	// Name - The name of the evaluation.
	Name *string `json:"name,omitempty"`
	// StartTime - The start time of the evaluation.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the evaluation.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Policies - Additional Learning settings to evaluate.
	Policies *[]PolicyContract `json:"policies,omitempty"`
}

// InternalError an object containing more specific information than the parent object about the error.
type InternalError struct {
	// Code - Detailed error code.
	Code *string `json:"code,omitempty"`
	// Innererror - The error object.
	Innererror *InternalError `json:"innererror,omitempty"`
}

// ListEvaluation ...
type ListEvaluation struct {
	autorest.Response `json:"-"`
	Value             *[]Evaluation `json:"value,omitempty"`
}

// LogsProperties ...
type LogsProperties struct {
	autorest.Response `json:"-"`
	// DateRange - READ-ONLY
	DateRange *LogsPropertiesDateRange `json:"dateRange,omitempty"`
}

// LogsPropertiesDateRange ...
type LogsPropertiesDateRange struct {
	// From - READ-ONLY
	From *date.Time `json:"from,omitempty"`
	// To - READ-ONLY
	To *date.Time `json:"to,omitempty"`
}

// ModelProperties ...
type ModelProperties struct {
	autorest.Response `json:"-"`
	// CreationTime - READ-ONLY
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
}

// PolicyContract learning settings specifying how to train the model.
type PolicyContract struct {
	autorest.Response `json:"-"`
	// Name - Name of the Learning settings.
	Name *string `json:"name,omitempty"`
	// Arguments - Arguments of the Learning settings.
	Arguments *string `json:"arguments,omitempty"`
}

// PolicyResult ...
type PolicyResult struct {
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Arguments - READ-ONLY
	Arguments *string `json:"arguments,omitempty"`
	// Summary - READ-ONLY
	Summary *[]PolicyResultSummary `json:"summary,omitempty"`
	// TotalSummary - READ-ONLY
	TotalSummary *PolicyResultTotalSummary `json:"totalSummary,omitempty"`
}

// PolicyResultSummary ...
type PolicyResultSummary struct {
	// TimeStamp - READ-ONLY
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// IpsEstimatorNumerator - READ-ONLY
	IpsEstimatorNumerator *float64 `json:"ipsEstimatorNumerator,omitempty"`
	// IpsEstimatorDenominator - READ-ONLY
	IpsEstimatorDenominator *float64 `json:"ipsEstimatorDenominator,omitempty"`
	// SnipsEstimatorDenominator - READ-ONLY
	SnipsEstimatorDenominator *float64 `json:"snipsEstimatorDenominator,omitempty"`
	// AggregateTimeWindow - READ-ONLY
	AggregateTimeWindow *string  `json:"aggregateTimeWindow,omitempty"`
	NonZeroProbability  *float64 `json:"nonZeroProbability,omitempty"`
	// ConfidenceInterval - READ-ONLY
	ConfidenceInterval *float64 `json:"confidenceInterval,omitempty"`
	// SumOfSquares - READ-ONLY
	SumOfSquares *float64 `json:"sumOfSquares,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyResultSummary.
func (prs PolicyResultSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prs.NonZeroProbability != nil {
		objectMap["nonZeroProbability"] = prs.NonZeroProbability
	}
	return json.Marshal(objectMap)
}

// PolicyResultTotalSummary ...
type PolicyResultTotalSummary struct {
	// TimeStamp - READ-ONLY
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// IpsEstimatorNumerator - READ-ONLY
	IpsEstimatorNumerator *float64 `json:"ipsEstimatorNumerator,omitempty"`
	// IpsEstimatorDenominator - READ-ONLY
	IpsEstimatorDenominator *float64 `json:"ipsEstimatorDenominator,omitempty"`
	// SnipsEstimatorDenominator - READ-ONLY
	SnipsEstimatorDenominator *float64 `json:"snipsEstimatorDenominator,omitempty"`
	// AggregateTimeWindow - READ-ONLY
	AggregateTimeWindow *string  `json:"aggregateTimeWindow,omitempty"`
	NonZeroProbability  *float64 `json:"nonZeroProbability,omitempty"`
	// ConfidenceInterval - READ-ONLY
	ConfidenceInterval *float64 `json:"confidenceInterval,omitempty"`
	// SumOfSquares - READ-ONLY
	SumOfSquares *float64 `json:"sumOfSquares,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyResultTotalSummary.
func (prS PolicyResultTotalSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prS.NonZeroProbability != nil {
		objectMap["nonZeroProbability"] = prS.NonZeroProbability
	}
	return json.Marshal(objectMap)
}

// RankableAction an action with it's associated features used for ranking.
type RankableAction struct {
	// ID - Id of the action.
	ID *string `json:"id,omitempty"`
	// Features - List of dictionaries containing features.
	Features *[]interface{} `json:"features,omitempty"`
}

// RankedAction a ranked action with its resulting probability.
type RankedAction struct {
	// ID - READ-ONLY; Id of the action
	ID *string `json:"id,omitempty"`
	// Probability - READ-ONLY; Probability of the action
	Probability *float64 `json:"probability,omitempty"`
}

// RankRequest request a set of actions to be ranked by the Personalizer service.
type RankRequest struct {
	// ContextFeatures - Features of the context used for Personalizer as a
	// dictionary of dictionaries. This depends on the application, and
	// typically includes features about the current user, their
	// device, profile information, aggregated data about time and date, etc.
	// Features should not include personally identifiable information (PII),
	// unique UserIDs, or precise timestamps.
	ContextFeatures *[]interface{} `json:"contextFeatures,omitempty"`
	// Actions - The set of actions the Personalizer service can pick from.
	// The set should not contain more than 50 actions.
	// The order of the actions does not affect the rank result but the order
	// should match the sequence your application would have used to display them.
	// The first item in the array will be used as Baseline item in Offline evaluations.
	Actions *[]RankableAction `json:"actions,omitempty"`
	// ExcludedActions - The set of action ids to exclude from ranking.
	ExcludedActions *[]string `json:"excludedActions,omitempty"`
	// EventID - Optionally pass an eventId that uniquely identifies this Rank event.
	// If null, the service generates a unique eventId. The eventId will be used for
	// associating this request with its reward, as well as seeding the pseudo-random
	// generator when making a Personalizer call.
	EventID *string `json:"eventId,omitempty"`
	// DeferActivation - Send false if it is certain the rewardActionId in rank results will be shown to the user, therefore
	// Personalizer will expect a Reward call, otherwise it will assign the default
	// Reward to the event. Send true if it is possible the user will not see the
	// action specified in the rank results, because the page is rendering later, or the Rank results may be
	// overridden by code further downstream.
	DeferActivation *bool `json:"deferActivation,omitempty"`
}

// RankResponse returns which action to use as rewardActionId, and additional information about each action as
// a result of a Rank request.
type RankResponse struct {
	autorest.Response `json:"-"`
	// Ranking - READ-ONLY; The calculated ranking for the current request.
	Ranking *[]RankedAction `json:"ranking,omitempty"`
	// EventID - READ-ONLY; The eventId for the round trip from request to response.
	EventID *string `json:"eventId,omitempty"`
	// RewardActionID - READ-ONLY; The action chosen by the Personalizer service. This is the action your application should display, and for which to report the reward. This might not be the
	// first found in 'ranking' if an action in the request in first position was part of the excluded ids.
	RewardActionID *string `json:"rewardActionId,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RewardRequest reward given to a rank response.
type RewardRequest struct {
	// Value - Reward to be assigned to an action. Value should be between -1 and 1 inclusive.
	Value *float64 `json:"value,omitempty"`
}

// ServiceConfiguration the configuration of the service.
type ServiceConfiguration struct {
	autorest.Response `json:"-"`
	// RewardWaitTime - The time span waited until a request is marked with the default reward.
	// For example, PT5M (5 mins). For information about the time format,
	// see http://en.wikipedia.org/wiki/ISO_8601#Durations
	RewardWaitTime *string `json:"rewardWaitTime,omitempty"`
	// DefaultReward - The reward given if a reward is not received within the specified wait time.
	DefaultReward *float64 `json:"defaultReward,omitempty"`
	// RewardAggregation - The function used to process rewards, if multiple reward scores are received before rewardWaitTime is over.
	RewardAggregation *string `json:"rewardAggregation,omitempty"`
	// ExplorationPercentage - The percentage of rank responses that will use exploration.
	ExplorationPercentage *float64 `json:"explorationPercentage,omitempty"`
	// ModelExportFrequency - Personalizer will start using the most updated trained model for online ranks automatically every specified time period.
	// For example, PT5M (5 mins). For information about the time format,
	// see http://en.wikipedia.org/wiki/ISO_8601#Durations
	ModelExportFrequency *string `json:"modelExportFrequency,omitempty"`
	// LogMirrorEnabled - Flag indicates whether log mirroring is enabled.
	LogMirrorEnabled *bool `json:"logMirrorEnabled,omitempty"`
	// LogMirrorSasURI - Azure storage account container SAS URI for log mirroring.
	LogMirrorSasURI *string `json:"logMirrorSasUri,omitempty"`
	// LogRetentionDays - Number of days historical logs are to be maintained. -1 implies the logs will never be deleted.
	LogRetentionDays *int32 `json:"logRetentionDays,omitempty"`
}
