/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.highlighting;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.jinja.model.TagLibrary;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.django.util.DjangoPsiUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplateBraceMatcher
implements PairedBraceMatcher,
DjangoTemplateTokenTypes,
XmlAwareBraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(DJANGO_TAG_START, DJANGO_TAG_END, true)};
    private static final Map<IElementType, IElementType> PAIRING_TOKENS = Maps.newHashMap();

    public BracePair @NotNull [] getPairs() {
        if (PAIRS == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(0);
        }
        return PAIRS;
    }

    public boolean isStrictTagMatching(@NotNull FileType fileType, int braceGroupId) {
        if (fileType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(1);
        }
        return false;
    }

    public boolean areTagsCaseSensitive(@NotNull FileType fileType, int braceGroupId) {
        if (fileType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(2);
        }
        return true;
    }

    public String getTagName(@NotNull CharSequence fileText, @NotNull HighlighterIterator iterator) {
        String name;
        if (fileText == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(3);
        }
        if (iterator == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(4);
        }
        if ((name = DjangoTemplateBraceMatcher.getFullName(fileText, iterator)) != null && TagLibrary.startsWithEndPrefix((String)name)) {
            return TagLibrary.withoutEnd((String)name);
        }
        return name;
    }

    @Nullable
    private static String getFullName(CharSequence fileText, HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        String name = null;
        if (tokenType == DJANGO_TAG_START) {
            iterator.advance();
            IElementType tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            boolean wasWhiteSpace = false;
            if (DjangoTemplateBraceMatcher.isWhitespace(tokenType1)) {
                wasWhiteSpace = true;
                iterator.advance();
                IElementType iElementType = tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            }
            if (tokenType1 == DJANGO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            if (wasWhiteSpace) {
                iterator.retreat();
            }
            iterator.retreat();
        } else if (tokenType == DJANGO_TAG_END) {
            int balance = 0;
            int count = 0;
            IElementType tokenType1 = iterator.getTokenType();
            while (balance >= 0) {
                iterator.retreat();
                ++count;
                if (iterator.atEnd()) break;
                tokenType1 = iterator.getTokenType();
                if (tokenType1 == DJANGO_TAG_END) {
                    ++balance;
                    continue;
                }
                if (tokenType1 != DJANGO_TAG_NAME) continue;
                --balance;
            }
            if (tokenType1 == DJANGO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            while (count-- > 0) {
                iterator.advance();
            }
        }
        return name;
    }

    private static boolean isWhitespace(IElementType tokenType) {
        return DjangoPsiUtil.isWhitespace((IElementType)tokenType);
    }

    public int getBraceTokenGroupId(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(5);
        }
        if (tokenType == DjangoTemplateTokenTypes.DJANGO_TAG_START || tokenType == DjangoTemplateTokenTypes.DJANGO_TAG_END) {
            return 1;
        }
        return 0;
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        IElementType tokenType;
        if (iterator == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(6);
        }
        if (fileText == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(8);
        }
        if ((tokenType = iterator.getTokenType()) == DjangoTemplateTokenTypes.DJANGO_TAG_START) {
            String tagName = DjangoTemplateBraceMatcher.getFullName(fileText, iterator);
            return !TagLibrary.startsWithEndPrefix((String)tagName);
        }
        return false;
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        IElementType tokenType;
        if (iterator == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(9);
        }
        if (fileText == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(11);
        }
        if ((tokenType = iterator.getTokenType()) == DjangoTemplateTokenTypes.DJANGO_TAG_END && DjangoTemplateBraceMatcher.findEndTagStart(iterator)) {
            String tagName = DjangoTemplateBraceMatcher.getFullName(fileText, iterator);
            return TagLibrary.startsWithEndPrefix((String)tagName);
        }
        return false;
    }

    public boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2) {
        if (tokenType1 == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(12);
        }
        if (tokenType2 == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(13);
        }
        return tokenType2.equals(PAIRING_TOKENS.get(tokenType1));
    }

    public boolean isStructuralBrace(@NotNull HighlighterIterator iterator, @NotNull CharSequence text, @NotNull FileType fileType) {
        if (iterator == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(14);
        }
        if (text == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(15);
        }
        if (fileType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(16);
        }
        return true;
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(17);
        }
        return PAIRING_TOKENS.get(type);
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(18);
        }
        return true;
    }

    public int getCodeConstructStart(@NotNull PsiFile psiFile, int openingBraceOffset) {
        if (psiFile == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(19);
        }
        return openingBraceOffset;
    }

    private static boolean findEndTagStart(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        int balance = 0;
        int count = 0;
        while (balance >= 0) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            tokenType = iterator.getTokenType();
            if (tokenType == DJANGO_TAG_END) {
                ++balance;
                continue;
            }
            if (tokenType != DJANGO_TAG_START) continue;
            --balance;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return tokenType == DJANGO_TAG_START;
    }

    static {
        PAIRING_TOKENS.put(DjangoTemplateTokenTypes.DJANGO_TAG_START, DjangoTemplateTokenTypes.DJANGO_TAG_END);
        PAIRING_TOKENS.put(DjangoTemplateTokenTypes.DJANGO_TAG_END, DjangoTemplateTokenTypes.DJANGO_TAG_START);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/lang/template/highlighting/DjangoTemplateBraceMatcher";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/lang/template/highlighting/DjangoTemplateBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTagMatching";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "areTagsCaseSensitive";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBraceTokenGroupId";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLBraceToken";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isRBraceToken";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPairBraces";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isStructuralBrace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCodeConstructStart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }
}

