/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.celery.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.python.pro.celery.CeleryUtilsKt;
import com.intellij.python.pro.celery.completion.AbstractCelerySettingsCompletionContributor;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/django/packages/celery/completion/CeleryDjangoSettingsCompletionContributor;", "Lcom/intellij/python/pro/celery/completion/AbstractCelerySettingsCompletionContributor;", "<init>", "()V", "isRelevant", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "toSettingName", "", "intellij.python.django"})
public final class CeleryDjangoSettingsCompletionContributor
extends AbstractCelerySettingsCompletionContributor {
    public boolean isRelevant(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement element = psiElement;
        if (!Registry.Companion.is("django.celery.enabled", false)) {
            return false;
        }
        if (!DjangoFacet.isPresent((PsiElement)element)) {
            return false;
        }
        if (!DjangoPsiUtil.isSettingsPy((PsiElement)element)) {
            return false;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)element);
        PyFile pyFile = scopeOwner instanceof PyFile ? (PyFile)scopeOwner : null;
        if (pyFile == null) {
            return false;
        }
        PyFile file = pyFile;
        DjangoModelApi djangoModelApi = (DjangoModelApi)DjangoModelApi.Companion.create((PyElement)file).getSuccessOrNull();
        if (djangoModelApi == null) {
            return false;
        }
        DjangoModelApi modelApi = djangoModelApi;
        return Intrinsics.areEqual((Object)file.getOriginalFile().getVirtualFile(), (Object)modelApi.getSettingsFile());
    }

    @NotNull
    public String toSettingName(@NotNull String $this$toSettingName) {
        Intrinsics.checkNotNullParameter((Object)$this$toSettingName, (String)"<this>");
        return CeleryUtilsKt.toDjangoSetting((String)$this$toSettingName);
    }
}

