/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.restFramework;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.codeGen.DjangoCodeSupplier;
import com.intellij.python.django.codeGen.DjangoFileCreationUtils;
import com.intellij.python.django.codeGen.DjangoResolvedPlace;
import com.intellij.python.django.packages.restFramework.ref.DrfFQNamesProvider;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModelUtil;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.extensions.FQNamesProviderExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/python/django/packages/restFramework/DjangoSerializerForModelCodeSupplier;", "Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;", "modelClass", "Lcom/jetbrains/django/model/modelApi/DjangoModelClass;", "<init>", "(Lcom/jetbrains/django/model/modelApi/DjangoModelClass;)V", "findPlace", "Lcom/intellij/python/django/codeGen/DjangoResolvedPlace;", "generateModelSerializerClassName", "", "modelClassName", "generateCode", "Lcom/intellij/psi/PsiElement;", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "updateImports", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "addedElement", "updateImportForQualifiedName", "file", "qualifiedName", "anchor", "intellij.python.django"})
public final class DjangoSerializerForModelCodeSupplier
implements DjangoCodeSupplier {
    @NotNull
    private final DjangoModelClass modelClass;

    public DjangoSerializerForModelCodeSupplier(@NotNull DjangoModelClass modelClass) {
        Intrinsics.checkNotNullParameter((Object)modelClass, (String)"modelClass");
        this.modelClass = modelClass;
    }

    @Override
    @Nullable
    public DjangoResolvedPlace findPlace() {
        Module module = DjangoUtil.getDjangoModule((Project)this.modelClass.getPyClass().getProject());
        if (module == null) {
            return null;
        }
        Module module2 = module;
        List installedApps = DjangoUnnamedApplicationModelUtil.INSTANCE.collectInstalledAppsInProjectSync(module2);
        PsiFile psiFile = this.modelClass.getPyClass().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        DjangoUnnamedApplicationModel djangoAppModel = DjangoUnnamedApplicationModelUtil.INSTANCE.createFromFileInsideApp(psiFile, installedApps);
        DjangoUnnamedApplicationModel djangoUnnamedApplicationModel = djangoAppModel;
        if ((djangoUnnamedApplicationModel == null || (djangoUnnamedApplicationModel = djangoUnnamedApplicationModel.getApplicationRootFolder()) == null) && (djangoUnnamedApplicationModel = this.modelClass.getPyClass().getContainingFile().getContainingDirectory()) == null) {
            return null;
        }
        DjangoUnnamedApplicationModel parentDirectory = djangoUnnamedApplicationModel;
        return DjangoFileCreationUtils.INSTANCE.resolvePlace(this.modelClass.getPyClass(), (PsiDirectory)parentDirectory, "serializers");
    }

    private final String generateModelSerializerClassName(String modelClassName) {
        return modelClassName + "Serializer";
    }

    @Override
    @NotNull
    public PsiElement generateCode(@NotNull LanguageLevel languageLevel) {
        Intrinsics.checkNotNullParameter((Object)languageLevel, (String)"languageLevel");
        String string = this.modelClass.getPyClass().getName();
        if (string == null) {
            string = "";
        }
        String modelClassName = string;
        PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)this.modelClass.getPyClass().getProject());
        String djangoModelSerializerCode = StringsKt.trimIndent((String)("\nclass " + this.generateModelSerializerClassName(modelClassName) + "(serializers.ModelSerializer):\n    class Meta:\n       model = " + modelClassName + "\n       fields = '__all__'\n"));
        Object object = elementFactory.createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)this.modelClass.getPyClass())), PyClass.class, djangoModelSerializerCode);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createFromText(...)");
        return (PsiElement)object;
    }

    @Override
    public void updateImports(@NotNull PsiFile psiFile, @NotNull PsiElement addedElement) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)addedElement, (String)"addedElement");
        this.updateImportForQualifiedName(psiFile, this.modelClass.getPyClass().getQualifiedName(), addedElement);
        this.updateImportForQualifiedName(psiFile, FQNamesProviderExtKt.getFirstName((FQNamesProvider)DrfFQNamesProvider.MODEL_SERIALIZERS_MODULE), addedElement);
    }

    private final void updateImportForQualifiedName(PsiFile file, String qualifiedName, PsiElement anchor) {
        String string = PythonStringUtil.removeLastSuffix((String)qualifiedName, (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeLastSuffix(...)");
        String from = string;
        String name = PythonStringUtil.getLastSuffix((String)qualifiedName, (String)".");
        AddImportHelper.addOrUpdateFromImportStatement((PsiFile)file, (String)from, (String)name, null, null, (PsiElement)anchor);
    }
}

