/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.xml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webcomponents.descriptor.ComponentTagDescriptor;
import com.intellij.webcomponents.descriptor.ContentTagDescriptor;
import com.intellij.webcomponents.descriptor.ElementTagDescriptor;
import com.intellij.webcomponents.descriptor.PolymerElementTagDescriptor;
import com.intellij.webcomponents.descriptor.SimpleTagWithNameDescriptor;
import com.intellij.webcomponents.index.WebComponentsIndex;
import com.intellij.webcomponents.util.WebComponentsUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class WebComponentsDescriptorProvider
implements XmlElementDescriptorProvider {
    @Nullable
    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return null;
        }
        if (!HtmlUtil.isHtml5Context((XmlElement)tag)) {
            return null;
        }
        if (!WebComponentsUtil.hasPolymerJs((PsiElement)tag)) {
            return null;
        }
        String tagName = tag.getName();
        if (WebComponentsIndex.getNames(tag.getProject()).contains(tagName)) {
            return new ComponentTagDescriptor(tag);
        }
        if ("element".equalsIgnoreCase(tagName)) {
            return new ElementTagDescriptor(tag);
        }
        if (("polymer-element".equalsIgnoreCase(tagName) || "dom-module".equalsIgnoreCase(tagName)) && WebComponentsUtil.hasPolymerJs((PsiElement)tag)) {
            return new PolymerElementTagDescriptor(tag);
        }
        if ("shadow".equalsIgnoreCase(tagName)) {
            return new SimpleTagWithNameDescriptor(this, tag){

                @Override
                @Nullable
                public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
                    return null;
                }
            };
        }
        if ("content".equalsIgnoreCase(tagName)) {
            return new ContentTagDescriptor(tag);
        }
        return null;
    }
}

