/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.connection.statements.TypedOutParameter;
import com.intellij.database.remote.jdbc.RemoteArray;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStringArrayOutParameter;", "Lcom/intellij/database/dataSource/connection/statements/TypedOutParameter;", "", "", "index", "", "arrayTypeName", "<init>", "(ILjava/lang/String;)V", "getIndex", "()I", "getArrayTypeName", "()Ljava/lang/String;", "type", "getType", "scale", "getScale", "register", "", "statement", "Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "retrieve", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.database.dialects.oracle.ex"})
public final class OraStringArrayOutParameter
extends TypedOutParameter<List<? extends String>> {
    private final int index;
    @NotNull
    private final String arrayTypeName;

    public OraStringArrayOutParameter(int index, @NotNull String arrayTypeName) {
        Intrinsics.checkNotNullParameter((Object)arrayTypeName, (String)"arrayTypeName");
        this.index = index;
        this.arrayTypeName = arrayTypeName;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public final String getArrayTypeName() {
        return this.arrayTypeName;
    }

    public int getType() {
        return 2003;
    }

    public int getScale() {
        return 0;
    }

    public void register(@NotNull RemoteCallableStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        statement.registerOutParameter(this.getIndex(), this.getType(), this.arrayTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> retrieve(@NotNull RemoteCallableStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        RemoteArray remoteArray = statement.getArray(this.getIndex());
        if (remoteArray == null) {
            return CollectionsKt.emptyList();
        }
        RemoteArray dbArray = remoteArray;
        RemoteResultSet remoteResultSet = dbArray.getResultSet();
        if (remoteResultSet == null) {
            return CollectionsKt.emptyList();
        }
        try (RemoteResultSet rs = remoteResultSet;){
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                String s = rs.getString(2);
                if (s == null) continue;
                list.add(s);
            }
            List list2 = list;
            return list2;
        }
    }

    public final int component1() {
        return this.index;
    }

    @NotNull
    public final String component2() {
        return this.arrayTypeName;
    }

    @NotNull
    public final OraStringArrayOutParameter copy(int index, @NotNull String arrayTypeName) {
        Intrinsics.checkNotNullParameter((Object)arrayTypeName, (String)"arrayTypeName");
        return new OraStringArrayOutParameter(index, arrayTypeName);
    }

    public static /* synthetic */ OraStringArrayOutParameter copy$default(OraStringArrayOutParameter oraStringArrayOutParameter, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = oraStringArrayOutParameter.index;
        }
        if ((n2 & 2) != 0) {
            string = oraStringArrayOutParameter.arrayTypeName;
        }
        return oraStringArrayOutParameter.copy(n, string);
    }

    @NotNull
    public String toString() {
        return "OraStringArrayOutParameter(index=" + this.index + ", arrayTypeName=" + this.arrayTypeName + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.index);
        result = result * 31 + this.arrayTypeName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OraStringArrayOutParameter)) {
            return false;
        }
        OraStringArrayOutParameter oraStringArrayOutParameter = (OraStringArrayOutParameter)((Object)other);
        if (this.index != oraStringArrayOutParameter.index) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.arrayTypeName, (Object)oraStringArrayOutParameter.arrayTypeName);
    }
}

