/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.javascript.testing.vitest.VitestConfigurationType;
import com.intellij.javascript.testing.vitest.VitestDetector;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.javascript.testing.vitest.VitestWatchProvider;
import com.intellij.javascript.testing.vitest.config.VitestConfig;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002*+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u001e\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\b\u0018\u00010\u0013R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\b\u0018\u00010\u0013R\u00020\u00002\u0006\u0010\f\u001a\u00020\u001aH\u0002J\u0016\u0010\u001c\u001a\b\u0018\u00010\u0013R\u00020\u00002\u0006\u0010\f\u001a\u00020\u001aH\u0002J\u0016\u0010\u001d\u001a\b\u0018\u00010\u0013R\u00020\u00002\u0006\u0010\f\u001a\u00020\u001aH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#H\u0002J \u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationProducer;", "Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer;", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getTestFrameworkDetector", "Lcom/intellij/javascript/testing/vitest/VitestDetector;", "setupConfigurationFromCompatibleContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromCompatibleContext", "buildContextSettings", "Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationProducer$ExtendedSettings;", "element", "templateRunSettings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "buildDirectorySettings", "psiDirectory", "Lcom/intellij/psi/PsiDirectory;", "Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationProducer$Context;", "buildSuiteOrTestSettings", "buildConfigSettings", "buildTestFileSettings", "findContextSuiteOrTestPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "getContainingJsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "guessWorkingDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "contextFile", "fixWorkingDir", "settings", "contextFileOrDir", "ExtendedSettings", "Context", "intellij.javascript.backend"})
public final class VitestRunConfigurationProducer
extends JsTestRunConfigurationProducer<VitestRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return (ConfigurationFactory)VitestConfigurationType.Companion.getInstance();
    }

    @Override
    @NotNull
    public VitestDetector getTestFrameworkDetector() {
        return VitestDetector.Companion.getInstance();
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull VitestRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement element2 = context2.getPsiLocation();
        if (element2 == null || !this.isTestRunnerAvailableFor(element2, context2)) {
            return false;
        }
        ExtendedSettings extendedSettings = this.buildContextSettings(element2, configuration.getSettings());
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        configuration.setSettings(extendedSettings2.getSettings());
        if (!VitestWatchProvider.Util.INSTANCE.isExplicitWatchOrRunMode(configuration)) {
            VitestWatchProvider.Util.INSTANCE.configureWatchMode$intellij_javascript_backend(configuration, configuration.getSettings().getScope().getKind() == JsTestRunScopeKind.ALL);
        }
        sourceElement.set((Object)extendedSettings2.getEnclosingElement());
        configuration.setGeneratedName();
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull VitestRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element2 = psiElement;
        RunConfiguration runConfiguration = this.cloneTemplateConfiguration(context2).getConfiguration();
        VitestRunConfiguration vitestRunConfiguration = runConfiguration instanceof VitestRunConfiguration ? (VitestRunConfiguration)runConfiguration : null;
        if (vitestRunConfiguration == null) {
            return false;
        }
        VitestRunConfiguration templateConfiguration = vitestRunConfiguration;
        ExtendedSettings extendedSettings = this.buildContextSettings(element2, templateConfiguration.getSettings());
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        VitestRunSettings thisRunSettings = extendedSettings2.getSettings();
        VitestRunSettings thatRunSettings = configuration.getSettings();
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)thisRunSettings.getConfigFilePath()), (Object)FileUtil.toSystemIndependentName((String)thatRunSettings.getConfigFilePath())) && Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)thisRunSettings.getWorkingDir()), (Object)FileUtil.toSystemIndependentName((String)thatRunSettings.getWorkingDir())) && Intrinsics.areEqual((Object)thisRunSettings.getScope().normalize(), (Object)thatRunSettings.getScope().normalize());
    }

    private final ExtendedSettings buildContextSettings(PsiElement element2, VitestRunSettings templateRunSettings) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (virtualFile == null) {
            return null;
        }
        Context context2 = new Context(element2, element2.getContainingFile(), virtualFile, templateRunSettings);
        if (element2 instanceof PsiDirectory) {
            return this.buildDirectorySettings((PsiDirectory)element2, context2);
        }
        ExtendedSettings extendedSettings = this.buildSuiteOrTestSettings(context2);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        extendedSettings = this.buildConfigSettings(context2);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        return this.buildTestFileSettings(context2);
    }

    private final ExtendedSettings buildDirectorySettings(PsiDirectory psiDirectory, Context context2) {
        VirtualFile virtualFile = context2.getFile();
        Project project = psiDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (Intrinsics.areEqual((Object)virtualFile, (Object)ProjectUtil.guessProjectDir((Project)project)) || VitestConfig.INSTANCE.findDefaultConfigFile(context2.getFile()) != null) {
            return new ExtendedSettings(context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)VitestRunConfigurationProducer::buildDirectorySettings$lambda$0)).build(), context2.getFile(), (PsiElement)psiDirectory);
        }
        VitestDetector vitestDetector = VitestDetector.Companion.getInstance();
        Project project2 = psiDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (!vitestDetector.hasTestsUnderDirectory(project2, context2.getFile())) {
            return null;
        }
        return new ExtendedSettings(context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)arg_0 -> VitestRunConfigurationProducer.buildDirectorySettings$lambda$1(context2, arg_0))).build(), context2.getFile(), (PsiElement)psiDirectory);
    }

    private final ExtendedSettings buildSuiteOrTestSettings(Context context2) {
        JsTestElementPath jsTestElementPath = this.findContextSuiteOrTestPath(context2.getElement());
        if (jsTestElementPath == null) {
            return null;
        }
        JsTestElementPath testPath = jsTestElementPath;
        VitestRunSettings.Builder builder2 = context2.getTemplateRunSettings().builder();
        JsTestRunScope.Builder builder3 = builder2.getScope().builder();
        String string = context2.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        builder2.setScope(builder3.testFilePath(string).build());
        String testName = testPath.getTestName();
        if (testName == null) {
            JsTestRunScope.Builder builder4 = builder2.getScope().builder().kind(JsTestRunScopeKind.SUITE);
            List<String> list = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuiteNames(...)");
            builder2.setScope(builder4.testNames(list).build());
        } else {
            JsTestRunScope.Builder builder5 = builder2.getScope().builder().kind(JsTestRunScopeKind.TEST);
            List<String> list = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuiteNames(...)");
            builder2.setScope(builder5.testNames(CollectionsKt.plus((Collection)list, (Object)testName)).build());
        }
        VitestRunSettings vitestRunSettings = builder2.build();
        VirtualFile virtualFile = context2.getFile();
        PsiElement psiElement = testPath.getTestElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getTestElement(...)");
        return new ExtendedSettings(vitestRunSettings, virtualFile, psiElement);
    }

    private final ExtendedSettings buildConfigSettings(Context context2) {
        JSProperty testProperty;
        if (context2.getPsiFile() != null && VitestConfig.INSTANCE.isConfigFile(context2.getFile()) && ((testProperty = VitestConfig.INSTANCE.findAncestorTestConfigProperty(context2.getElement())) != null || VitestConfig.INSTANCE.isVitestConfigFile(context2.getFile()))) {
            VitestRunSettings settings = context2.getTemplateRunSettings().builder().scope(context2.getTemplateRunSettings().getScope().builder().kind(JsTestRunScopeKind.ALL).build()).build();
            JSProperty jSProperty = testProperty;
            return new ExtendedSettings(settings, context2.getFile(), jSProperty != null ? (PsiElement)jSProperty : (PsiElement)context2.getPsiFile());
        }
        return null;
    }

    private final ExtendedSettings buildTestFileSettings(Context context2) {
        PsiFile psiFile = context2.getPsiFile();
        JSFile jSFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        if (VitestDetector.Companion.getInstance().hasTestsInFile(jsFile)) {
            VitestRunSettings.Builder builder2 = context2.getTemplateRunSettings().builder();
            JsTestRunScope.Builder builder3 = builder2.getScope().builder().kind(JsTestRunScopeKind.TEST_FILE);
            String string = context2.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            builder2.setScope(builder3.testFilePath(string).build());
            return new ExtendedSettings(builder2.build(), context2.getFile(), (PsiElement)context2.getPsiFile());
        }
        return null;
    }

    private final JsTestElementPath findContextSuiteOrTestPath(PsiElement element2) {
        AbstractTestFileStructure vitestTestsStructure;
        if (element2 instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jSFile = this.getContainingJsFile(element2);
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        TextRange textRange = element2.getTextRange();
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        AbstractTestFileStructure abstractTestFileStructure = vitestTestsStructure = VitestDetector.Companion.getInstance().findTestsStructure(jsFile);
        return abstractTestFileStructure != null ? abstractTestFileStructure.findTestElementPath(textRange2) : null;
    }

    private final JSFile getContainingJsFile(PsiElement element2) {
        PsiFile psiFile = element2.getContainingFile();
        return psiFile instanceof JSFile ? (JSFile)psiFile : null;
    }

    private final VirtualFile guessWorkingDir(Project project, VirtualFile contextFile) {
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref firstPackageJsonDir = ref2;
        AtomicBoolean basedOnVitestDeclaredDependency = new AtomicBoolean(false);
        VirtualFile workingDir = (VirtualFile)JSProjectUtil.processDirectoriesUpToContentRootAndFindFirst(project, contextFile, arg_0 -> VitestRunConfigurationProducer.guessWorkingDir$lambda$1(arg_0 -> VitestRunConfigurationProducer.guessWorkingDir$lambda$0(firstPackageJsonDir, this, basedOnVitestDeclaredDependency, project, arg_0), arg_0));
        VirtualFile firstPackageJson = (VirtualFile)firstPackageJsonDir.get();
        if (firstPackageJson != null && !Intrinsics.areEqual((Object)firstPackageJson, (Object)workingDir) && basedOnVitestDeclaredDependency.get()) {
            return firstPackageJson;
        }
        return workingDir;
    }

    private final VitestRunSettings fixWorkingDir(VitestRunSettings settings, VirtualFile contextFileOrDir, Project project) {
        VirtualFile virtualFile;
        if (StringsKt.isBlank((CharSequence)settings.getWorkingDir()) && (virtualFile = this.guessWorkingDir(project, contextFileOrDir)) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            VitestRunSettings.Builder builder2 = settings.builder();
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return builder2.workingDir(string).build();
        }
        return settings;
    }

    private static final Unit buildDirectorySettings$lambda$0(JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.ALL);
        return Unit.INSTANCE;
    }

    private static final Unit buildDirectorySettings$lambda$1(Context $context, JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.DIRECTORY);
        String string = $context.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        it.testDirectoryPath(string);
        return Unit.INSTANCE;
    }

    private static final VirtualFile guessWorkingDir$lambda$0(Ref $firstPackageJsonDir, VitestRunConfigurationProducer this$0, AtomicBoolean $basedOnVitestDeclaredDependency, Project $project, VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile defaultConfigFile = VitestConfig.INSTANCE.findDefaultConfigFile(dir);
        if (defaultConfigFile != null) {
            return dir;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
        if (packageJson != null) {
            $firstPackageJsonDir.setIfNull((Object)dir);
            PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
            Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
            PackageJsonData data2 = packageJsonData;
            VitestDetector detector = this$0.getTestFrameworkDetector();
            if (detector.getPackageDescriptor().isFrameworkDeclaredInPackageJson(data2)) {
                $basedOnVitestDeclaredDependency.set(true);
                return dir;
            }
            if (JsTestRunConfigurationProducer.Companion.hasTestScript($project, packageJson, data2)) {
                return dir;
            }
        }
        return null;
    }

    private static final VirtualFile guessWorkingDir$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationProducer$Context;", "", "element", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "templateRunSettings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/javascript/testing/vitest/VitestRunSettings;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTemplateRunSettings", "()Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "intellij.javascript.backend"})
    private static final class Context {
        @NotNull
        private final PsiElement element;
        @Nullable
        private final PsiFile psiFile;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final VitestRunSettings templateRunSettings;

        public Context(@NotNull PsiElement element2, @Nullable PsiFile psiFile, @NotNull VirtualFile file, @NotNull VitestRunSettings templateRunSettings) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)templateRunSettings, (String)"templateRunSettings");
            this.element = element2;
            this.psiFile = psiFile;
            this.file = file;
            this.templateRunSettings = templateRunSettings;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @Nullable
        public final PsiFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final VitestRunSettings getTemplateRunSettings() {
            return this.templateRunSettings;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationProducer$ExtendedSettings;", "", "initialSettings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "enclosingElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationProducer;Lcom/intellij/javascript/testing/vitest/VitestRunSettings;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiElement;)V", "getEnclosingElement", "()Lcom/intellij/psi/PsiElement;", "settings", "getSettings", "()Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "intellij.javascript.backend"})
    private final class ExtendedSettings {
        @NotNull
        private final PsiElement enclosingElement;
        @NotNull
        private final VitestRunSettings settings;

        public ExtendedSettings(@NotNull VitestRunSettings initialSettings, @NotNull VirtualFile contextFileOrDir, PsiElement enclosingElement) {
            Intrinsics.checkNotNullParameter((Object)initialSettings, (String)"initialSettings");
            Intrinsics.checkNotNullParameter((Object)contextFileOrDir, (String)"contextFileOrDir");
            Intrinsics.checkNotNullParameter((Object)enclosingElement, (String)"enclosingElement");
            this.enclosingElement = enclosingElement;
            Project project = this.enclosingElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.settings = VitestRunConfigurationProducer.this.fixWorkingDir(initialSettings, contextFileOrDir, project).modify((Function1<? super VitestRunSettings.Builder, Unit>)((Function1)ExtendedSettings::settings$lambda$0));
        }

        @NotNull
        public final PsiElement getEnclosingElement() {
            return this.enclosingElement;
        }

        @NotNull
        public final VitestRunSettings getSettings() {
            return this.settings;
        }

        private static final Unit settings$lambda$0(VitestRunSettings.Builder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setScope(it.getScope().normalize());
            return Unit.INSTANCE;
        }
    }
}

