/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.types.impl;

import com.intellij.javascript.types.TSNumberLiteralType;
import com.intellij.javascript.types.impl.TSCompilerType;
import com.intellij.javascript.types.impl.TSTypeImplUtilsKt;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.typescript.tsc.gen.NumberLiteralType;
import com.intellij.lang.typescript.tsc.gen.Type;
import com.intellij.lang.typescript.tsc.refreshable.TscRefreshableType;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/types/impl/TSNumberLiteralTypeImpl;", "Lcom/intellij/javascript/types/impl/TSCompilerType;", "Lcom/intellij/javascript/types/TSNumberLiteralType;", "tscType", "Lcom/intellij/lang/typescript/tsc/refreshable/TscRefreshableType;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/lang/typescript/tsc/refreshable/TscRefreshableType;Lcom/intellij/openapi/project/Project;)V", "value", "", "getValue", "()Ljava/lang/Number;", "isFreshLiteralType", "", "asJSType", "Lcom/intellij/lang/javascript/psi/JSType;", "intellij.javascript.backend"})
public final class TSNumberLiteralTypeImpl
extends TSCompilerType
implements TSNumberLiteralType {
    @NotNull
    private final Number value;
    private final boolean isFreshLiteralType;

    public TSNumberLiteralTypeImpl(@NotNull TscRefreshableType<?> tscType, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(tscType, (String)"tscType");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(tscType, project);
        Object t = tscType.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.NumberLiteralType");
        this.value = ((NumberLiteralType)t).getValue();
        this.isFreshLiteralType = TSTypeImplUtilsKt.isFreshLiteralType((Type)tscType.getValue());
    }

    @NotNull
    public Number getValue() {
        return this.value;
    }

    @NotNull
    public JSType asJSType() {
        double d;
        if (this.getValue() instanceof Integer) {
            d = this.getValue().intValue();
        } else {
            Number number = this.getValue();
            Intrinsics.checkNotNull((Object)number, (String)"null cannot be cast to non-null type kotlin.Double");
            d = (Double)number;
        }
        double doubleValue = d;
        String valueAsString = this.getValue() instanceof Integer ? String.valueOf(this.getValue().intValue()) : null;
        return (JSType)new JSNumberLiteralTypeImpl(doubleValue, this.isFreshLiteralType, TSTypeImplUtilsKt.getJS_TYPE_SOURCE(), valueAsString);
    }
}

