/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.util;

import com.intellij.javascript.util.JsPathUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=5, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001b\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a#\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"getPathRelativeToContentRoot", "", "Lcom/intellij/openapi/util/NlsSafe;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "prependContentRootName", "", "intellij.javascript.backend"}, xs="com/intellij/javascript/util/JsPathUtil")
final class JsPathUtil__JsPathUtilKt {
    @NotNull
    public static final String getPathRelativeToContentRoot(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JsPathUtil.getPathRelativeToContentRoot(project, file, true);
    }

    @NotNull
    public static final String getPathRelativeToContentRoot(@NotNull Project project, @NotNull VirtualFile file, boolean prependContentRootName) {
        String relativePath;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile((Project)project, (VirtualFile)file);
        if (contentRoot != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)File.separatorChar)) != null) {
            Object object;
            if (!prependContentRootName) {
                return relativePath;
            }
            if (((CharSequence)relativePath).length() == 0) {
                String string = file.getName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            } else {
                object = contentRoot.getName() + File.separatorChar + relativePath;
            }
            return object;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
        return string;
    }
}

