/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSChangeModifierIntentionBase
extends JavaScriptIntention
implements LowPriorityAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element2) && this.supportsModifier(element2) && (this.checkForField(element2) || this.checkForFunction(project, element2));
    }

    protected abstract boolean supportsModifier(@NotNull PsiElement var1);

    protected boolean isPrivateSharp() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        JSVariable field;
        if (project == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(3);
        }
        if ((field = this.getField(element2)) != null) {
            this.invokeForField(field);
            return;
        }
        JSFunction method = this.getFunction(element2);
        if (method != null) {
            this.invokeForFunction(project, method);
        }
    }

    private void invokeForField(@NotNull JSVariable field) {
        if (field == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(4);
        }
        JSVisibilityUtil.Options defaultVisibilityOptions = JSVisibilityUtil.DEFAULT_OPTIONS;
        JSAttributeList.AccessType newVisibility = this.getInspectionAccessType();
        MultiMap conflicts = new MultiMap();
        ArrayList allReferences = new ArrayList();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).asIterable().forEach(reference -> {
            if (reference instanceof JSElement) {
                JSRefactoringConflictsUtil.checkAccessibility((JSAttributeListOwner)field, null, newVisibility.toString(), (PsiElement)((JSElement)reference), (MultiMap<PsiElement, String>)conflicts, true, defaultVisibilityOptions);
                if (reference instanceof JSReferenceExpression) {
                    allReferences.add((JSReferenceExpression)reference);
                }
            }
        })), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, field.getProject())) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)field.getProject(), (MultiMap)conflicts)) {
            return;
        }
        boolean sharp = this.isPrivateSharp();
        ApplicationManager.getApplication().runWriteAction(() -> {
            boolean wasSharp = JSUtils.isPrivateSharpItem((PsiElement)field);
            JSAttributeListWrapper wrapper = JSChangeVisibilityUtil.createVisibilityOverrideWrapper((JSAttributeListOwner)field, newVisibility, null);
            if (wrapper == null) {
                return;
            }
            if (sharp) {
                wrapper.setForcePrivateSharp(true);
            }
            wrapper.applyTo((JSAttributeListOwner)field, true);
            JSRefactoringUtil.updateRefSharpness(allReferences, sharp, wasSharp);
        });
    }

    private void invokeForFunction(@NotNull Project project, @NotNull JSFunction method) {
        if (project == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(5);
        }
        if (method == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(6);
        }
        if ((method = this.getParentFunction(method, project)) == null) {
            return;
        }
        boolean wasSharp = JSUtils.isPrivateSharpItem((PsiElement)method);
        boolean isSharp = this.isPrivateSharp();
        ArrayList allReferences = new ArrayList();
        if (wasSharp || isSharp) {
            JSFunction finalMethod = method;
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)finalMethod, (SearchScope)finalMethod.getUseScope()).asIterable().forEach(reference -> {
                if (reference instanceof JSReferenceExpression) {
                    allReferences.add((JSReferenceExpression)reference);
                }
            })), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, finalMethod.getProject());
        }
        JSParameterInfo[] infos = (JSParameterInfo[])ContainerUtil.toArray(JSMethodDescriptor.getParameters(method), JSParameterInfo.ARRAY_FACTORY);
        JSType type2 = method.getReturnType();
        String stringType = type2 == null ? null : type2.getTypeText(JSType.TypeTextFormat.CODE);
        PsiElement returnTypeElement = method.getReturnTypeElement();
        SmartPsiElementPointer methodPointer = SmartPointerManager.createPointer((PsiElement)method);
        JSChangeSignatureProcessor processor = new JSChangeSignatureProcessor(method, this.getInspectionAccessType(), method.getName(), returnTypeElement == null ? null : stringType, infos, Collections.emptySet(), Collections.emptySet(), this.isPrivateSharp());
        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
        processor.run();
        if ((wasSharp || isSharp) && JSUtils.isPrivateSharpItem((PsiElement)methodPointer.getElement()) == isSharp) {
            ApplicationManager.getApplication().runWriteAction(() -> JSRefactoringUtil.updateRefSharpness(allReferences, isSharp, wasSharp));
        }
    }

    @Nullable
    protected JSFunction getParentFunction(@Nullable JSFunction method, @NotNull Project project) {
        if (project == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(7);
        }
        if (method == null) {
            return null;
        }
        Map map2 = JSInheritanceUtil.findDeclaringClassesMap((JSQualifiedNamedElement)method);
        if (map2.size() != 1) {
            return method;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map2.entrySet());
        if (item == null) {
            return method;
        }
        JSPsiElementBase value = (JSPsiElementBase)item.getValue();
        if (!(value instanceof JSFunction)) {
            return null;
        }
        if (value.equals((Object)method)) {
            return method;
        }
        return this.getParentFunction((JSFunction)value, project);
    }

    protected boolean checkForFunction(@NotNull Project project, @NotNull PsiElement element2) {
        JSClass parentClass;
        JSFunction function;
        if (project == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(9);
        }
        if ((function = this.getFunction(element2)) == null || function.getAttributeList() == null || function.isConstructor()) {
            return false;
        }
        JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)function);
        if (jsClass == null || jsClass.isInterface()) {
            return false;
        }
        JSFunction parentFunction = this.getParentFunction(function, project);
        if (parentFunction != function && ((parentClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) == null || parentClass.isInterface())) {
            return false;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)function, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.ABSTRACT) && this.getInspectionAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)function);
        return modifier != this.getInspectionAccessType();
    }

    protected boolean checkForField(@NotNull PsiElement element2) {
        JSVariable field;
        if (element2 == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(10);
        }
        if ((field = this.getField(element2)) == null || field.getAttributeList() == null) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)field);
        if (modifier == this.getInspectionAccessType()) {
            return false;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)field, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.ABSTRACT) && this.getInspectionAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return false;
        }
        Collection members = JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)field);
        return members.stream().anyMatch(el -> el == field);
    }

    @Nullable
    protected JSAttributeList.AccessType getCurrentModifier(@NotNull JSAttributeListOwner owner) {
        JSAttributeList list;
        if (owner == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(11);
        }
        if ((list = owner.getAttributeList()) == null) {
            return null;
        }
        return list.getAccessType();
    }

    @Nullable
    protected JSVariable getField(@NotNull PsiElement current) {
        JSVariable variable;
        if (current == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(12);
        }
        if ((variable = JavaScriptIntention.findParentVariable(current, JSVariable.class)) == null) {
            return null;
        }
        return JSUtils.isMember((PsiElement)variable) ? variable : null;
    }

    @Nullable
    protected JSFunction getFunction(@NotNull PsiElement current) {
        if (current == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(13);
        }
        return JavaScriptIntention.findParentNamedElement(current, JSFunction.class);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"typescript.fix.change.member.access", (Object[])new Object[]{JSVisibilityUtil.accessTypeToKeyword((JSAttributeList.AccessType)this.getInspectionAccessType(), (DialectOptionHolder)DialectOptionHolder.TS)});
        if (string == null) {
            JSChangeModifierIntentionBase.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public abstract JSAttributeList.AccessType getInspectionAccessType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSChangeModifierIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSChangeModifierIntentionBase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeForField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeForFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentFunction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkForFunction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkForField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentModifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15 -> new IllegalStateException(string);
        };
    }
}

