/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.loc;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.util.ClosestPointChecker;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.MathUtil;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PathTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PointTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PolygonTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.RectTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TargetDetector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetDetector;", "", "locatorLookupSpace", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpace;", "locatorLookupStrategy", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupStrategy;", "(Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpace;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupStrategy;)V", "checkPath", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PathTargetProjection$PathPoint;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "cursorCoord", "pathProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PathTargetProjection;", "closestPointChecker", "Lorg/jetbrains/letsPlot/commons/intern/util/ClosestPointChecker;", "checkPoint", "", "pointProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PointTargetProjection;", "checkPolygon", "polygonProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection;", "checkRect", "rectProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/RectTargetProjection;", "rangeBasedLookup", "cursor", "range", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "byX", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nTargetDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetDetector.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1313#2,2:232\n1#3:234\n1774#4,4:235\n*S KotlinDebug\n*F\n+ 1 TargetDetector.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetDetector\n*L\n64#1:232,2\n166#1:235,4\n*E\n"})
public final class TargetDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeomTargetLocator.LookupSpace locatorLookupSpace;
    @NotNull
    private final GeomTargetLocator.LookupStrategy locatorLookupStrategy;
    private static final double POINT_AREA_EPSILON = 5.1;
    private static final double RECT_X_NEAREST_EPSILON = 2.0;

    public TargetDetector(@NotNull GeomTargetLocator.LookupSpace locatorLookupSpace, @NotNull GeomTargetLocator.LookupStrategy locatorLookupStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)locatorLookupSpace), (String)"locatorLookupSpace");
        Intrinsics.checkNotNullParameter((Object)((Object)locatorLookupStrategy), (String)"locatorLookupStrategy");
        this.locatorLookupSpace = locatorLookupSpace;
        this.locatorLookupStrategy = locatorLookupStrategy;
    }

    @Nullable
    public final Pair<PathTargetProjection.PathPoint, DoubleVector> checkPath(@NotNull DoubleVector cursorCoord, @NotNull PathTargetProjection pathProjection, @NotNull ClosestPointChecker closestPointChecker) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)pathProjection, (String)"pathProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        if (pathProjection.getPoints().isEmpty()) {
            return null;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                pair2 = null;
                break;
            }
            case 2: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        pair2 = null;
                        break block0;
                    }
                    case 2: {
                        pair2 = TuplesKt.to((Object)TargetDetector.Companion.searchNearest(cursorCoord.getX(), pathProjection.getPoints(), checkPath.lookupResult.1.INSTANCE), null);
                        break block0;
                    }
                    case 3: {
                        if (cursorCoord.getX() < ((PathTargetProjection.PathPoint)CollectionsKt.first(pathProjection.getPoints())).projection().x() || cursorCoord.getX() > ((PathTargetProjection.PathPoint)CollectionsKt.last(pathProjection.getPoints())).projection().x()) {
                            pair2 = null;
                            break block0;
                        }
                        pair2 = TuplesKt.to((Object)TargetDetector.Companion.searchNearest(cursorCoord.getX(), pathProjection.getPoints(), checkPath.lookupResult.2.INSTANCE), null);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        pair2 = null;
                        break block0;
                    }
                    case 2: {
                        pair2 = TuplesKt.to((Object)TargetDetector.Companion.searchNearest(cursorCoord.getY(), pathProjection.getPoints(), checkPath.lookupResult.3.INSTANCE), null);
                        break block0;
                    }
                    case 3: {
                        if (cursorCoord.getY() < ((PathTargetProjection.PathPoint)CollectionsKt.first(pathProjection.getPoints())).projection().y() || cursorCoord.getY() > ((PathTargetProjection.PathPoint)CollectionsKt.last(pathProjection.getPoints())).projection().y()) {
                            pair2 = null;
                            break block0;
                        }
                        pair2 = TuplesKt.to((Object)TargetDetector.Companion.searchNearest(cursorCoord.getY(), pathProjection.getPoints(), checkPath.lookupResult.4.INSTANCE), null);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        pair2 = null;
                        break block0;
                    }
                    case 3: {
                        PathTargetProjection.PathPoint candidate = null;
                        Sequence $this$forEach$iv = SequencesKt.windowed$default((Sequence)CollectionsKt.asSequence((Iterable)pathProjection.getPoints()), (int)2, (int)0, (boolean)false, (int)6, null);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            DoubleVector p2;
                            List it = (List)element$iv;
                            boolean bl = false;
                            DoubleVector p1 = ((PathTargetProjection.PathPoint)it.get(0)).projection().xy();
                            if (MathKt.isOnSegment(cursorCoord, p1, p2 = ((PathTargetProjection.PathPoint)it.get(1)).projection().xy())) {
                                DoubleVector targetPointCoord = MathKt.projection(cursorCoord, p1, p2);
                                if (!ClosestPointChecker.check$default(closestPointChecker, targetPointCoord, 0.0, 2, null)) continue;
                                candidate = TuplesKt.to(it.get(0), (Object)targetPointCoord);
                                continue;
                            }
                            if (!ClosestPointChecker.check$default(closestPointChecker, p1, 0.0, 2, null)) continue;
                            candidate = TuplesKt.to(it.get(0), (Object)p1);
                        }
                        pair2 = candidate;
                        break block0;
                    }
                    case 2: {
                        PathTargetProjection.PathPoint candidate = null;
                        for (PathTargetProjection.PathPoint pathPoint : pathProjection.getPoints()) {
                            DoubleVector targetPointCoord = pathPoint.projection().xy();
                            if (!ClosestPointChecker.check$default(closestPointChecker, targetPointCoord, 0.0, 2, null)) continue;
                            candidate = pathPoint;
                        }
                        PathTargetProjection.PathPoint pathPoint = candidate;
                        if (pathPoint != null) {
                            PathTargetProjection.PathPoint it = pathPoint;
                            boolean bl = false;
                            pair2 = TuplesKt.to(it, null);
                            break block0;
                        }
                        pair2 = null;
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair lookupResult2 = pair2;
        return lookupResult2;
    }

    public final boolean checkPoint(@NotNull DoubleVector cursorCoord, @NotNull PointTargetProjection pointProjection, @NotNull ClosestPointChecker closestPointChecker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)pointProjection, (String)"pointProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder(pointProjection.x(), cursorCoord.getX(), pointProjection.getRadius() + 5.1);
                        break block0;
                    }
                    case 2: {
                        bl = ClosestPointChecker.check$default(closestPointChecker, new DoubleVector(pointProjection.x(), 0.0), 0.0, 2, null);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder(pointProjection.y(), cursorCoord.getY(), pointProjection.getRadius() + 5.1);
                        break block0;
                    }
                    case 2: {
                        bl = ClosestPointChecker.check$default(closestPointChecker, new DoubleVector(0.0, pointProjection.y()), 0.0, 2, null);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder(pointProjection.xy(), cursorCoord, pointProjection.getRadius() + 5.1);
                        break block0;
                    }
                    case 2: {
                        bl = closestPointChecker.check(pointProjection.xy(), pointProjection.getRadius() + 5.1);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean checkRect(@NotNull DoubleVector cursorCoord, @NotNull RectTargetProjection rectProjection, @NotNull ClosestPointChecker closestPointChecker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)rectProjection, (String)"rectProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, rectProjection.x(), true);
                break;
            }
            case 3: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, rectProjection.y(), false);
                break;
            }
            case 4: {
                DoubleRectangle rect2 = rectProjection.xy();
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 3: {
                        bl = rect2.contains(cursorCoord);
                        break block0;
                    }
                    case 2: {
                        if (rect2.contains(cursorCoord)) {
                            bl = ClosestPointChecker.check$default(closestPointChecker, cursorCoord, 0.0, 2, null);
                            break block0;
                        }
                        double x2 = cursorCoord.getX() < rect2.getLeft() ? rect2.getLeft() : rect2.getRight();
                        double y2 = cursorCoord.getY() < rect2.getTop() ? rect2.getTop() : rect2.getBottom();
                        x2 = rect2.xRange().contains(cursorCoord.getX()) ? cursorCoord.getX() : x2;
                        y2 = rect2.yRange().contains(cursorCoord.getY()) ? cursorCoord.getY() : y2;
                        bl = ClosestPointChecker.check$default(closestPointChecker, new DoubleVector(x2, y2), 0.0, 2, null);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean checkPolygon(@NotNull DoubleVector cursorCoord, @NotNull PolygonTargetProjection polygonProjection, @NotNull ClosestPointChecker closestPointChecker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)polygonProjection, (String)"polygonProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.locatorLookupSpace.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, polygonProjection.x(), true);
                break;
            }
            case 3: {
                bl = this.rangeBasedLookup(cursorCoord, closestPointChecker, polygonProjection.y(), false);
                break;
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
                    case 1: {
                        bl = false;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        int n;
                        Iterable $this$count$iv = polygonProjection.xy();
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                PolygonTargetProjection.RingXY it = (PolygonTargetProjection.RingXY)element$iv;
                                boolean bl2 = false;
                                if (!it.contains(cursorCoord) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        if (n % 2 != 0) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean rangeBasedLookup(DoubleVector cursor, ClosestPointChecker closestPointChecker, DoubleSpan range, boolean byX) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.locatorLookupStrategy.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 3: {
                bl = range.contains(byX ? cursor.getX() : cursor.getY());
                break;
            }
            case 2: {
                double cursorCoord;
                double d = cursorCoord = byX ? cursor.getX() : cursor.getY();
                if (range.contains(cursorCoord - 2.0) || range.contains(cursorCoord + 2.0)) {
                    DoubleVector coord;
                    DoubleVector doubleVector = coord = byX ? new DoubleVector(range.getLowerEnd() + range.getLength() / (double)2, cursor.getY()) : new DoubleVector(cursor.getX(), range.getLowerEnd() + range.getLength() / (double)2);
                    if (ClosestPointChecker.compareObject$default(closestPointChecker, coord, 0.0, 2, null) != ClosestPointChecker.COMPARISON_RESULT.NEW_FARTHER) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00040\fH\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetDetector$Companion;", "", "()V", "POINT_AREA_EPSILON", "", "RECT_X_NEAREST_EPSILON", "searchNearest", "T", "value", "items", "", "mapper", "Lkotlin/Function1;", "(DLjava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T searchNearest(double value, List<? extends T> items, Function1<? super T, Double> mapper) {
            if (value < ((Number)mapper.invoke(CollectionsKt.first(items))).doubleValue()) {
                return (T)CollectionsKt.first(items);
            }
            if (value > ((Number)mapper.invoke(CollectionsKt.last(items))).doubleValue()) {
                return (T)CollectionsKt.last(items);
            }
            int lo = 0;
            int hi = CollectionsKt.getLastIndex(items);
            while (lo <= hi) {
                int mid = (hi + lo) / 2;
                double midValue = ((Number)mapper.invoke(items.get(mid))).doubleValue();
                if (value < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (value > midValue) {
                    lo = mid + 1;
                    continue;
                }
                return items.get(mid);
            }
            return ((Number)mapper.invoke(items.get(lo))).doubleValue() - value < value - ((Number)mapper.invoke(items.get(hi))).doubleValue() ? items.get(lo) : items.get(hi);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GeomTargetLocator.LookupStrategy.values().length];
            try {
                nArray[GeomTargetLocator.LookupStrategy.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupStrategy.NEAREST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupStrategy.HOVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GeomTargetLocator.LookupSpace.values().length];
            try {
                nArray[GeomTargetLocator.LookupSpace.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.Y.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.XY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

